/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.common.NoSuchRecordException;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ChangesetAction;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.UserRowMapper;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class UserDao {
    private static final String SELECT_USER = "SELECT id, name FROM users WHERE id = ?";
    private static final String INSERT_USER = "INSERT INTO users(id, name) VALUES(?, ?)";
    private static final String UPDATE_USER = "UPDATE users SET name = ? WHERE id = ?";
    private JdbcTemplate jdbcTemplate;
    private ActionDao actionDao;
    private UserRowMapper rowMapper;

    public UserDao(DatabaseContext dbCtx, ActionDao actionDao) {
        this.actionDao = actionDao;
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
        this.rowMapper = new UserRowMapper();
    }

    public OsmUser getUser(long userId) {
        OsmUser user;
        try {
            user = (OsmUser)this.jdbcTemplate.queryForObject(SELECT_USER, (RowMapper)this.rowMapper, new Object[]{userId});
        }
        catch (EmptyResultDataAccessException e) {
            throw new NoSuchRecordException("User " + userId + " doesn't exist.", e);
        }
        return user;
    }

    public void addUser(OsmUser user) {
        this.jdbcTemplate.update(INSERT_USER, new Object[]{user.getId(), user.getName()});
        this.actionDao.addAction(ActionDataType.USER, ChangesetAction.CREATE, user.getId());
    }

    public void updateUser(OsmUser user) {
        this.jdbcTemplate.update(UPDATE_USER, new Object[]{user.getName(), user.getId()});
        this.actionDao.addAction(ActionDataType.USER, ChangesetAction.MODIFY, user.getId());
    }
}

