/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.Map;
import org.openstreetmap.osmosis.core.database.DbOrderedFeature;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.EntityFeatureMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.MemberTypeValueMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.RelationMemberRowMapper;
import org.springframework.jdbc.core.RowMapper;

public class RelationMemberMapper
extends EntityFeatureMapper<DbOrderedFeature<RelationMember>> {
    private MemberTypeValueMapper memberTypeValueMapper = new MemberTypeValueMapper();

    @Override
    public String getParentEntityName() {
        return "relation";
    }

    @Override
    public String getEntityName() {
        return "relation_members";
    }

    @Override
    public String getSqlSelect(String tablePrefix, boolean filterByEntityId, boolean orderBy) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("SELECT relation_id AS entity_id, member_id, member_type, member_role, sequence_id FROM ");
        resultSql.append("relation_members f");
        if (!tablePrefix.isEmpty()) {
            resultSql.append(" INNER JOIN ").append(tablePrefix).append(this.getParentEntityName()).append("s e ON f.").append(this.getParentEntityName()).append("_id = e.id");
        }
        if (filterByEntityId) {
            resultSql.append(" WHERE relation_id = ?");
        }
        if (orderBy) {
            resultSql.append(this.getSqlDefaultOrderBy());
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDefaultOrderBy() {
        return super.getSqlDefaultOrderBy() + ", sequence_id";
    }

    @Override
    public String getSqlInsert(int rowCount) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("INSERT INTO relation_members (");
        resultSql.append("relation_id, member_id, member_type, member_role, sequence_id) VALUES ");
        for (int row = 0; row < rowCount; ++row) {
            if (row > 0) {
                resultSql.append(", ");
            }
            resultSql.append("(:relationId, :memberId, :memberType, :memberRole, :sequenceId)");
        }
        return resultSql.toString();
    }

    @Override
    public String getSqlDelete(boolean filterByEntityId) {
        StringBuilder resultSql = new StringBuilder();
        resultSql.append("DELETE FROM relation_members");
        if (filterByEntityId) {
            resultSql.append(" WHERE ").append("relation_id = ?");
        }
        return resultSql.toString();
    }

    @Override
    public void populateParameters(Map<String, Object> args, DbOrderedFeature<RelationMember> feature) {
        RelationMember relationMember = (RelationMember)feature.getFeature();
        args.put("relationId", feature.getEntityId());
        args.put("memberId", relationMember.getMemberId());
        args.put("memberType", this.memberTypeValueMapper.getMemberType(relationMember.getMemberType()));
        args.put("memberRole", relationMember.getMemberRole());
        args.put("sequenceId", feature.getSequenceId());
    }

    @Override
    public RowMapper<DbOrderedFeature<RelationMember>> getRowMapper() {
        return new RelationMemberRowMapper();
    }
}

