/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.FeatureCollectionLoader;
import org.openstreetmap.osmosis.core.database.FeaturePopulator;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.PeekableIterator;
import org.openstreetmap.osmosis.core.store.Storeable;

public class FeaturePopulatorImpl<Te extends Entity, Tf extends Storeable, Tdbf extends DbFeature<Tf>>
implements FeaturePopulator<Te> {
    private PeekableIterator<Tdbf> source;
    private FeatureCollectionLoader<Te, Tf> featureLoader;

    public FeaturePopulatorImpl(ReleasableIterator<Tdbf> source, FeatureCollectionLoader<Te, Tf> featureLoader) {
        this.source = new PeekableIterator(source);
        this.featureLoader = featureLoader;
    }

    public void populateFeatures(Te entity) {
        while (this.source.hasNext() && ((DbFeature)this.source.peekNext()).getEntityId() == entity.getId()) {
            this.featureLoader.getFeatureCollection(entity).add(((DbFeature)this.source.next()).getFeature());
        }
    }

    public void close() {
        this.source.close();
    }
}

