/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.postgis.jdbc.geometry.Geometry;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.lifecycle.Completable;
import org.openstreetmap.osmosis.core.lifecycle.CompletableContainer;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.hstore.PGHStore;
import org.openstreetmap.osmosis.pgsnapshot.common.CopyFileWriter;
import org.openstreetmap.osmosis.pgsnapshot.common.NodeLocationStoreType;
import org.openstreetmap.osmosis.pgsnapshot.common.PointBuilder;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.CopyFileset;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.MemberTypeValueMapper;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.WayGeometryBuilder;
import org.postgresql.util.PGobject;

public class CopyFilesetBuilder
implements Sink,
EntityProcessor {
    private boolean enableBboxBuilder;
    private boolean enableLinestringBuilder;
    private boolean enableKeepPartialLinestring;
    private boolean keepInvalidWays;
    private WayGeometryBuilder wayGeometryBuilder;
    private CompletableContainer writerContainer;
    private MemberTypeValueMapper memberTypeValueMapper;
    private CopyFileWriter userWriter;
    private CopyFileWriter nodeWriter;
    private CopyFileWriter wayWriter;
    private CopyFileWriter wayNodeWriter;
    private CopyFileWriter relationWriter;
    private CopyFileWriter relationMemberWriter;
    private PointBuilder pointBuilder;
    private Set<Integer> userSet;

    public CopyFilesetBuilder(CopyFileset copyFileset, boolean enableBboxBuilder, boolean enableLinestringBuilder, boolean enableKeepPartialLinestring, NodeLocationStoreType storeType, boolean keepInvalidWays) {
        this.enableBboxBuilder = enableBboxBuilder;
        this.enableLinestringBuilder = enableLinestringBuilder;
        this.enableKeepPartialLinestring = enableKeepPartialLinestring;
        this.keepInvalidWays = keepInvalidWays;
        this.writerContainer = new CompletableContainer();
        this.userWriter = (CopyFileWriter)this.writerContainer.add((Completable)new CopyFileWriter(copyFileset.getUserFile()));
        this.nodeWriter = (CopyFileWriter)this.writerContainer.add((Completable)new CopyFileWriter(copyFileset.getNodeFile()));
        this.wayWriter = (CopyFileWriter)this.writerContainer.add((Completable)new CopyFileWriter(copyFileset.getWayFile()));
        this.wayNodeWriter = (CopyFileWriter)this.writerContainer.add((Completable)new CopyFileWriter(copyFileset.getWayNodeFile()));
        this.relationWriter = (CopyFileWriter)this.writerContainer.add((Completable)new CopyFileWriter(copyFileset.getRelationFile()));
        this.relationMemberWriter = (CopyFileWriter)this.writerContainer.add((Completable)new CopyFileWriter(copyFileset.getRelationMemberFile()));
        this.pointBuilder = new PointBuilder();
        this.wayGeometryBuilder = new WayGeometryBuilder(storeType);
        this.memberTypeValueMapper = new MemberTypeValueMapper();
        this.memberTypeValueMapper = new MemberTypeValueMapper();
        this.userSet = new HashSet<Integer>();
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(EntityContainer entityContainer) {
        OsmUser user = entityContainer.getEntity().getUser();
        if (!user.equals((Object)OsmUser.NONE) && !this.userSet.contains(user.getId())) {
            this.userWriter.writeField(user.getId());
            this.userWriter.writeField(user.getName());
            this.userWriter.endRecord();
            this.userSet.add(user.getId());
        }
        entityContainer.process((EntityProcessor)this);
    }

    public void process(BoundContainer boundContainer) {
    }

    private PGHStore buildTags(Entity entity) {
        PGHStore tags = new PGHStore();
        for (Tag tag : entity.getTags()) {
            tags.put(tag.getKey(), tag.getValue());
        }
        return tags;
    }

    public void process(NodeContainer nodeContainer) {
        Node node = nodeContainer.getEntity();
        this.nodeWriter.writeField(node.getId());
        this.nodeWriter.writeField(node.getVersion());
        this.nodeWriter.writeField(node.getUser().getId());
        this.nodeWriter.writeField(node.getTimestamp());
        this.nodeWriter.writeField(node.getChangesetId());
        this.nodeWriter.writeField((PGobject)this.buildTags((Entity)node));
        this.nodeWriter.writeField((Geometry)this.pointBuilder.createPoint(node.getLatitude(), node.getLongitude()));
        this.nodeWriter.endRecord();
        if (this.enableBboxBuilder || this.enableLinestringBuilder) {
            this.wayGeometryBuilder.addNodeLocation(node);
        }
    }

    public void process(WayContainer wayContainer) {
        Way way = wayContainer.getEntity();
        ArrayList<Long> nodeIds = new ArrayList<Long>(way.getWayNodes().size());
        for (WayNode wayNode : way.getWayNodes()) {
            nodeIds.add(wayNode.getNodeId());
        }
        if (way.getWayNodes().size() > 1 || this.keepInvalidWays) {
            this.wayWriter.writeField(way.getId());
            this.wayWriter.writeField(way.getVersion());
            this.wayWriter.writeField(way.getUser().getId());
            this.wayWriter.writeField(way.getTimestamp());
            this.wayWriter.writeField(way.getChangesetId());
            this.wayWriter.writeField((PGobject)this.buildTags((Entity)way));
            this.wayWriter.writeField(nodeIds);
            if (this.enableBboxBuilder) {
                this.wayWriter.writeField((Geometry)this.wayGeometryBuilder.createWayBbox(way));
            }
            if (this.enableLinestringBuilder) {
                this.wayWriter.writeField((Geometry)this.wayGeometryBuilder.createWayLinestring(way, this.enableKeepPartialLinestring));
            }
            this.wayWriter.endRecord();
            int sequenceId = 0;
            for (WayNode wayNode : way.getWayNodes()) {
                this.wayNodeWriter.writeField(way.getId());
                this.wayNodeWriter.writeField(wayNode.getNodeId());
                this.wayNodeWriter.writeField(sequenceId++);
                this.wayNodeWriter.endRecord();
            }
        }
    }

    public void process(RelationContainer relationContainer) {
        Relation relation = relationContainer.getEntity();
        this.relationWriter.writeField(relation.getId());
        this.relationWriter.writeField(relation.getVersion());
        this.relationWriter.writeField(relation.getUser().getId());
        this.relationWriter.writeField(relation.getTimestamp());
        this.relationWriter.writeField(relation.getChangesetId());
        this.relationWriter.writeField((PGobject)this.buildTags((Entity)relation));
        this.relationWriter.endRecord();
        int memberSequenceId = 0;
        for (RelationMember member : relation.getMembers()) {
            this.relationMemberWriter.writeField(relation.getId());
            this.relationMemberWriter.writeField(member.getMemberId());
            this.relationMemberWriter.writeField(this.memberTypeValueMapper.getMemberType(member.getMemberType()));
            this.relationMemberWriter.writeField(member.getMemberRole());
            this.relationMemberWriter.writeField(memberSequenceId++);
            this.relationMemberWriter.endRecord();
        }
    }

    public void complete() {
        this.writerContainer.complete();
    }

    public void close() {
        this.writerContainer.close();
        this.wayGeometryBuilder.close();
    }
}

