/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.v0_6.impl;

import org.openstreetmap.osmosis.pgsnapshot.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.ChangesetAction;
import org.openstreetmap.osmosis.pgsnapshot.v0_6.impl.DatabaseCapabilityChecker;
import org.springframework.jdbc.core.JdbcTemplate;

public class ActionDao {
    private static final String SQL_INSERT = "INSERT INTO actions(data_type, action, id) VALUES(?, ?, ?)";
    private static final String SQL_TRUNCATE = "TRUNCATE actions";
    private JdbcTemplate jdbcTemplate;
    private DatabaseCapabilityChecker capabilityChecker;

    public ActionDao(DatabaseContext dbCtx) {
        this.jdbcTemplate = dbCtx.getJdbcTemplate();
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
    }

    public void addAction(ActionDataType dataType, ChangesetAction action, long id) {
        if (this.capabilityChecker.isActionSupported()) {
            this.jdbcTemplate.update(SQL_INSERT, new Object[]{dataType.getDatabaseValue(), action.getDatabaseValue(), id});
        }
    }

    public void truncate() {
        if (this.capabilityChecker.isActionSupported()) {
            this.jdbcTemplate.update(SQL_TRUNCATE);
        }
    }
}

