/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsnapshot.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.pgsnapshot.common.DataSourceManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DatabaseContext
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(DatabaseContext.class.getName());
    private DataSourceManager dataSourceManager;
    private DataSource dataSource;
    private PlatformTransactionManager txnManager;
    private TransactionTemplate txnTemplate;
    private TransactionStatus transaction;
    private JdbcTemplate jdbcTemplate;

    public DatabaseContext(DatabaseLoginCredentials loginCredentials) {
        this.dataSourceManager = new DataSourceManager(loginCredentials);
        this.dataSource = this.dataSourceManager.getDataSource();
        this.txnManager = new DataSourceTransactionManager(this.dataSource);
        this.txnTemplate = new TransactionTemplate(this.txnManager);
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.setStatementFetchSizeForStreaming();
        if (loginCredentials.getPostgresSchema() != "") {
            this.jdbcTemplate.execute("SELECT set_config('search_path', '" + loginCredentials.getPostgresSchema() + ",' || current_setting('search_path'), false)");
        }
    }

    public void beginTransaction() {
        if (this.transaction != null) {
            throw new OsmosisRuntimeException("A transaction is already active.");
        }
        this.transaction = this.txnManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
    }

    public void commitTransaction() {
        if (this.transaction == null) {
            throw new OsmosisRuntimeException("No transaction is currently active.");
        }
        try {
            this.txnManager.commit(this.transaction);
        }
        finally {
            this.transaction = null;
        }
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public <T> Object executeWithinTransaction(TransactionCallback<T> txnCallback) {
        return this.txnTemplate.execute(txnCallback);
    }

    private void setStatementFetchSizeForStreaming() {
        this.jdbcTemplate.setFetchSize(10000);
    }

    @Override
    public void close() {
        if (this.transaction != null) {
            try {
                this.txnManager.rollback(this.transaction);
            }
            finally {
                this.transaction = null;
            }
        }
        this.dataSourceManager.close();
    }

    public boolean doesColumnExist(String tableName, String columnName) {
        LOG.finest("Checking if column {" + columnName + "} in table {" + tableName + "} exists.");
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            boolean bl;
            block11: {
                ResultSet resultSet = connection.getMetaData().getColumns(null, null, tableName, columnName);
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new OsmosisRuntimeException("Unable to check for the existence of column " + tableName + "." + columnName + ".", (Throwable)e);
                    }
                }
                resultSet.close();
            }
            return bl;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    public boolean doesTableExist(String tableName) {
        LOG.finest("Checking if table {" + tableName + "} exists.");
        Connection connection = DataSourceUtils.getConnection((DataSource)this.dataSource);
        try {
            boolean bl;
            block11: {
                ResultSet resultSet = connection.getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        throw new OsmosisRuntimeException("Unable to check for the existence of table " + tableName + ".", (Throwable)e);
                    }
                }
                resultSet.close();
            }
            return bl;
        }
        finally {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        }
    }

    public void loadCopyFile(File copyFile, String tableName, String ... columns) {
        StringBuilder copyStatement = new StringBuilder();
        copyStatement.append("COPY ");
        copyStatement.append(tableName);
        if (columns.length > 0) {
            copyStatement.append('(');
            for (int i = 0; i < columns.length; ++i) {
                if (i > 0) {
                    copyStatement.append(',');
                }
                copyStatement.append(columns[i]);
            }
            copyStatement.append(')');
        }
        copyStatement.append(" FROM STDIN");
        try (BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(copyFile), 65536);){
            Connection conn = DataSourceUtils.getConnection((DataSource)this.dataSource);
            try {
                CopyManager copyManager = new CopyManager(conn.unwrap(BaseConnection.class));
                copyManager.copyIn(copyStatement.toString(), (InputStream)inStream);
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to process COPY file " + copyFile + ".", (Throwable)e);
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)conn, (DataSource)this.dataSource);
            }
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to process COPY file " + copyFile + ".", (Throwable)e);
        }
    }
}

