/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.replication.v0_6;

import java.io.File;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.task.common.RunnableTask;
import org.openstreetmap.osmosis.core.util.FileBasedLock;
import org.openstreetmap.osmosis.core.util.ResourceFileManager;

public class ReplicationDownloaderInitializer
implements RunnableTask {
    private static final String LOCK_FILE_NAME = "download.lock";
    private static final String CONFIG_FILE_NAME = "configuration.txt";
    private static final String CONFIG_RESOURCE = "impl/replicationDownloaderConfiguration.txt";
    private File workingDirectory;

    public ReplicationDownloaderInitializer(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    private void initializeDirectory() {
        ResourceFileManager resourceFileManager = new ResourceFileManager();
        File configFile = new File(this.workingDirectory, CONFIG_FILE_NAME);
        if (configFile.exists()) {
            throw new OsmosisRuntimeException("Config file configuration.txt already exists.");
        }
        resourceFileManager.copyResourceToFile(this.getClass(), CONFIG_RESOURCE, configFile);
    }

    public void run() {
        try (FileBasedLock fileLock = new FileBasedLock(new File(this.workingDirectory, LOCK_FILE_NAME));){
            fileLock.lock();
            this.initializeDirectory();
            fileLock.unlock();
        }
    }
}

