/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.tagfilter.v0_6;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class TagFilter
implements SinkSource {
    private Sink sink;
    private Set<String> tagKeys;
    private Map<String, Set<String>> tagKeyValues;
    private Class<? extends EntityContainer> filterClass;
    private boolean reject;
    private boolean matchesEverything;
    private static final Logger LOG = Logger.getLogger(TagFilter.class.getName());

    public TagFilter(String filterMode, Set<String> tagKeys, Map<String, Set<String>> tagKeyValues) {
        String[] filterModeSplit = filterMode.toLowerCase().split("-");
        if (filterModeSplit.length != 2) {
            throw new OsmosisRuntimeException("The TagFilter task's default parameter must consist of an action and an entity type separated by '-'.");
        }
        String action = filterModeSplit[0];
        if (action.equals("accept")) {
            this.reject = false;
        } else if (action.equals("reject")) {
            this.reject = true;
        } else {
            throw new OsmosisRuntimeException("The TagFilter action must be either 'accept' or 'reject'. '" + action + "' is not a supported mode.");
        }
        String entity = filterModeSplit[1];
        if (entity.endsWith("s")) {
            entity = entity.substring(0, entity.length() - 1);
        }
        if (entity.equals("node")) {
            this.filterClass = NodeContainer.class;
        } else if (entity.equals("way")) {
            this.filterClass = WayContainer.class;
        } else if (entity.equals("relation")) {
            this.filterClass = RelationContainer.class;
        } else {
            throw new OsmosisRuntimeException("The TagFilter entity type must be one of 'node', 'way', or 'relation'. '" + entity + "' is not a supported entity type.");
        }
        this.matchesEverything = tagKeys.size() == 0 && tagKeyValues.size() == 0;
        this.tagKeys = tagKeys;
        this.tagKeyValues = tagKeyValues;
        Object logString = "New TagFilter ";
        logString = this.reject ? (String)logString + "rejects " : (String)logString + "accepts ";
        logString = (String)logString + this.filterClass;
        logString = this.matchesEverything ? (String)logString + " (no tag-based filtering)." : (String)logString + " having tag keys " + tagKeys + " or tag key-value pairs " + tagKeyValues + ".";
        LOG.finer((String)logString);
    }

    private boolean matches(EntityContainer container) {
        boolean matched = false;
        for (Tag tag : container.getEntity().getTags()) {
            String key = tag.getKey();
            if (this.tagKeys.contains(key)) {
                matched = true;
                break;
            }
            Set<String> values = this.tagKeyValues.get(key);
            if (values == null || !values.contains(tag.getValue())) continue;
            matched = true;
            break;
        }
        return matched;
    }

    public void initialize(Map<String, Object> metaData) {
        this.sink.initialize(metaData);
    }

    public void process(EntityContainer container) {
        if (this.filterClass.isInstance(container)) {
            if (this.reject ^ (this.matchesEverything || this.matches(container))) {
                this.sink.process(container);
            }
        } else {
            this.sink.process(container);
        }
    }

    public void complete() {
        this.sink.complete();
    }

    public void close() {
        this.sink.close();
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

