/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.store;

import java.io.DataOutput;
import java.io.IOException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.store.StoreWriter;

public class DataOutputStoreWriter
implements StoreWriter {
    private DataOutput output;

    public DataOutputStoreWriter(DataOutput output) {
        this.output = output;
    }

    @Override
    public void writeBoolean(boolean value) {
        try {
            this.output.writeBoolean(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write boolean " + value + " to the store.", e);
        }
    }

    @Override
    public void writeByte(byte value) {
        try {
            this.output.writeByte(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write byte " + value + " to the store.", e);
        }
    }

    @Override
    public void writeCharacter(char value) {
        try {
            this.output.writeChar(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write character " + value + " to the store.", e);
        }
    }

    @Override
    public void writeInteger(int value) {
        try {
            this.output.writeInt(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write integer " + value + " to the store.", e);
        }
    }

    @Override
    public void writeLong(long value) {
        try {
            this.output.writeLong(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write long " + value + " to the store.", e);
        }
    }

    @Override
    public void writeDouble(double value) {
        try {
            this.output.writeDouble(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write double " + value + " to the store.", e);
        }
    }

    @Override
    public void writeString(String value) {
        try {
            this.output.writeUTF(value);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write String (" + value + ") to the store.", e);
        }
    }
}

