/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.sort.v0_6;

import java.util.Comparator;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.task.common.ChangeAction;

public class ChangeForSeekableApplierComparator
implements Comparator<ChangeContainer> {
    private int calculateSortWeight(ChangeContainer changeEntity) {
        ChangeAction action = changeEntity.getAction();
        Entity entity = changeEntity.getEntityContainer().getEntity();
        if (entity.getType().equals((Object)EntityType.Bound)) {
            if (action.equals((Object)ChangeAction.Create)) {
                return 1;
            }
            if (action.equals((Object)ChangeAction.Modify)) {
                return 8;
            }
            if (action.equals((Object)ChangeAction.Delete)) {
                return 12;
            }
        } else if (entity.getType().equals((Object)EntityType.Node)) {
            if (action.equals((Object)ChangeAction.Create)) {
                return 2;
            }
            if (action.equals((Object)ChangeAction.Modify)) {
                return 7;
            }
            if (action.equals((Object)ChangeAction.Delete)) {
                return 11;
            }
        } else if (entity.getType().equals((Object)EntityType.Way)) {
            if (action.equals((Object)ChangeAction.Create)) {
                return 3;
            }
            if (action.equals((Object)ChangeAction.Modify)) {
                return 6;
            }
            if (action.equals((Object)ChangeAction.Delete)) {
                return 10;
            }
        } else if (entity.getType().equals((Object)EntityType.Relation)) {
            if (action.equals((Object)ChangeAction.Create)) {
                return 4;
            }
            if (action.equals((Object)ChangeAction.Modify)) {
                return 5;
            }
            if (action.equals((Object)ChangeAction.Delete)) {
                return 9;
            }
        }
        throw new OsmosisRuntimeException("The change entity with action " + action + " type " + entity.getType() + " and id " + entity.getId() + " was not recognised.");
    }

    @Override
    public int compare(ChangeContainer o1, ChangeContainer o2) {
        return this.calculateSortWeight(o1) - this.calculateSortWeight(o2);
    }
}

