/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.progress.v0_6;

import java.util.Map;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.progress.v0_6.impl.ProgressTracker;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.core.task.v0_6.SinkSource;

public class EntityProgressLogger
implements SinkSource {
    private static final Logger LOG = Logger.getLogger(EntityProgressLogger.class.getName());
    private Sink sink;
    private ProgressTracker progressTracker;
    private String prefix;

    public EntityProgressLogger(int interval, String label) {
        this.progressTracker = new ProgressTracker(interval);
        this.prefix = label != null && !label.equals("") ? "[" + label + "] " : "";
    }

    @Override
    public void initialize(Map<String, Object> metaData) {
        this.progressTracker.initialize();
        this.sink.initialize(metaData);
    }

    @Override
    public void process(EntityContainer entityContainer) {
        Entity entity = entityContainer.getEntity();
        if (this.progressTracker.updateRequired()) {
            LOG.info(this.prefix + "Processing " + entity.getType() + " " + entity.getId() + ", " + this.progressTracker.getObjectsPerSecond() + " objects/second.");
        }
        this.sink.process(entityContainer);
    }

    @Override
    public void complete() {
        LOG.info("Processing completion steps.");
        long start = System.currentTimeMillis();
        this.sink.complete();
        long duration = System.currentTimeMillis() - start;
        LOG.info("Completion steps took " + (double)duration / 1000.0 + " seconds.");
        LOG.info("Processing complete.");
    }

    @Override
    public void close() {
        this.sink.close();
    }

    @Override
    public void setSink(Sink sink) {
        this.sink = sink;
    }
}

