/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.pipeline.common;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;
import org.openstreetmap.osmosis.core.pipeline.common.TaskManager;

public abstract class TaskManagerFactory {
    private static final String DATE_FORMAT = "yyyy-MM-dd_HH:mm:ss";
    private static final Locale DATE_LOCALE = Locale.US;
    private ThreadLocal<Set<String>> accessedTaskOptions = new ThreadLocal();

    protected TaskManagerFactory() {
    }

    public TaskManager createTaskManager(TaskConfiguration taskConfig) {
        this.accessedTaskOptions.set(new HashSet());
        TaskManager taskManager = this.createTaskManagerImpl(taskConfig);
        for (String argName : taskConfig.getConfigArgs().keySet()) {
            if (this.accessedTaskOptions.get().contains(argName)) continue;
            throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " was not recognised.");
        }
        this.accessedTaskOptions.set(null);
        return taskManager;
    }

    protected abstract TaskManager createTaskManagerImpl(TaskConfiguration var1);

    protected boolean doesArgumentExist(TaskConfiguration taskConfig, String argName) {
        return taskConfig.getConfigArgs().containsKey(argName);
    }

    protected String getDefaultStringArgument(TaskConfiguration taskConfig, String defaultValue) {
        if (taskConfig.getDefaultArg() != null) {
            return taskConfig.getDefaultArg();
        }
        return defaultValue;
    }

    protected String getStringArgument(TaskConfiguration taskConfig, String argName) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            return configArgs.get(argName);
        }
        throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " does not exist.");
    }

    protected String getStringArgument(TaskConfiguration taskConfig, String argName, String defaultValue) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            return configArgs.get(argName);
        }
        return defaultValue;
    }

    protected int getDefaultIntegerArgument(TaskConfiguration taskConfig, int defaultValue) {
        String defaultArg = taskConfig.getDefaultArg();
        if (defaultArg != null) {
            try {
                return Integer.parseInt(defaultArg);
            }
            catch (NumberFormatException e) {
                throw new OsmosisRuntimeException("Default argument for task " + taskConfig.getId() + " must be an integer number.", e);
            }
        }
        return defaultValue;
    }

    protected int getIntegerArgument(TaskConfiguration taskConfig, String argName) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            try {
                return Integer.parseInt(configArgs.get(argName));
            }
            catch (NumberFormatException e) {
                throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " must be an integer number.", e);
            }
        }
        throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " does not exist.");
    }

    protected int getIntegerArgument(TaskConfiguration taskConfig, String argName, int defaultValue) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            try {
                return Integer.parseInt(configArgs.get(argName));
            }
            catch (NumberFormatException e) {
                throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " must be an integer number.", e);
            }
        }
        return defaultValue;
    }

    protected double getDoubleArgument(TaskConfiguration taskConfig, String argName, double defaultValue) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            try {
                return Double.parseDouble(configArgs.get(argName));
            }
            catch (NumberFormatException e) {
                throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " must be a decimal number.", e);
            }
        }
        return defaultValue;
    }

    protected Date getDateArgument(TaskConfiguration taskConfig, String argName, Date defaultValue) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
                return dateFormat.parse(configArgs.get(argName));
            }
            catch (ParseException e) {
                throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " must be a date in format yyyy-MM-dd_HH:mm:ss.", e);
            }
        }
        return defaultValue;
    }

    protected Date getDateArgument(TaskConfiguration taskConfig, String argName, TimeZone timeZone) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            try {
                SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT, DATE_LOCALE);
                dateFormat.setTimeZone(timeZone);
                return dateFormat.parse(configArgs.get(argName));
            }
            catch (ParseException e) {
                throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " must be a date in format yyyy-MM-dd_HH:mm:ss.", e);
            }
        }
        throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " does not exist.");
    }

    protected boolean getBooleanArgument(TaskConfiguration taskConfig, String argName, boolean defaultValue) {
        this.accessedTaskOptions.get().add(argName);
        Map<String, String> configArgs = taskConfig.getConfigArgs();
        if (configArgs.containsKey(argName)) {
            String rawValue = configArgs.get(argName).toLowerCase();
            if ("true".equals(rawValue) || "yes".equals(rawValue)) {
                return true;
            }
            if ("false".equals(rawValue) || "no".equals(rawValue)) {
                return false;
            }
            throw new OsmosisRuntimeException("Argument " + argName + " for task " + taskConfig.getId() + " must be one of yes, no, true or false.");
        }
        return defaultValue;
    }
}

