/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.core.cli;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.pipeline.common.TaskConfiguration;

public class CommandLineParser {
    private static final String GLOBAL_ARGUMENT_PREFIX = "-";
    private static final String TASK_ARGUMENT_PREFIX = "--";
    private static final String OPTION_QUIET_SHORT = "q";
    private static final String OPTION_QUIET_LONG = "quiet";
    private static final String OPTION_VERBOSE_SHORT = "v";
    private static final String OPTION_VERBOSE_LONG = "verbose";
    private static final String OPTION_PLUGIN_SHORT = "p";
    private static final String OPTION_PLUGIN_LONG = "plugin";
    private static final int DEFAULT_LOG_LEVEL_INDEX = 3;
    private List<TaskConfiguration> taskConfigList = new ArrayList<TaskConfiguration>();
    private int quietValue = 0;
    private int verboseValue = 0;
    private List<String> plugins = new ArrayList<String>();

    public void parse(String[] programArgs) {
        ArrayList<GlobalOptionConfiguration> globalOptions = new ArrayList<GlobalOptionConfiguration>();
        int i = 0;
        while (i < programArgs.length) {
            String arg = programArgs[i];
            if (arg.indexOf(TASK_ARGUMENT_PREFIX) == 0) {
                i = this.parseTask(programArgs, i);
                continue;
            }
            if (arg.indexOf(GLOBAL_ARGUMENT_PREFIX) == 0) {
                i = this.parseGlobalOption(globalOptions, programArgs, i);
                continue;
            }
            throw new OsmosisRuntimeException("Expected argument " + (i + 1) + " to be an option or task name.");
        }
        for (GlobalOptionConfiguration globalOption : globalOptions) {
            if (this.isArgumentForOption(OPTION_QUIET_SHORT, OPTION_QUIET_LONG, globalOption.name)) {
                this.quietValue = this.parseOptionIntegerWithDefault(globalOption, 0) + 1;
                continue;
            }
            if (this.isArgumentForOption(OPTION_VERBOSE_SHORT, OPTION_VERBOSE_LONG, globalOption.name)) {
                this.verboseValue = this.parseOptionIntegerWithDefault(globalOption, 0) + 1;
                continue;
            }
            if (this.isArgumentForOption(OPTION_PLUGIN_SHORT, OPTION_PLUGIN_LONG, globalOption.name)) {
                this.plugins.add(this.parseOptionString(globalOption));
                continue;
            }
            throw new OsmosisRuntimeException("Argument " + (globalOption.offset + 1) + " specifies an unrecognised option \"-" + globalOption.name + "\".");
        }
    }

    private boolean isArgumentForOption(String shortOptionName, String longOptionName, String argument) {
        return shortOptionName.equals(argument) || longOptionName.equals(argument);
    }

    private boolean isOptionParameter(String argument) {
        if (argument.length() >= GLOBAL_ARGUMENT_PREFIX.length() && argument.substring(0, GLOBAL_ARGUMENT_PREFIX.length()).equals(GLOBAL_ARGUMENT_PREFIX)) {
            return false;
        }
        return argument.length() < TASK_ARGUMENT_PREFIX.length() || !argument.substring(0, TASK_ARGUMENT_PREFIX.length()).equals(TASK_ARGUMENT_PREFIX);
    }

    private int parseOptionIntegerWithDefault(GlobalOptionConfiguration globalOption, int defaultValue) {
        int result;
        if (globalOption.parameters.size() <= 0) {
            return defaultValue;
        }
        if (globalOption.parameters.size() > 1) {
            throw new OsmosisRuntimeException("Expected argument " + (globalOption.offset + 1) + " to have no more than one parameter.");
        }
        try {
            result = Integer.parseInt(globalOption.parameters.get(0));
        }
        catch (NumberFormatException e) {
            throw new OsmosisRuntimeException("Expected argument " + (globalOption.offset + 2) + " to contain an integer value.");
        }
        return result;
    }

    private String parseOptionString(GlobalOptionConfiguration globalOption) {
        if (globalOption.parameters.size() != 1) {
            throw new OsmosisRuntimeException("Expected argument " + (globalOption.offset + 1) + " to have one parameter.");
        }
        return globalOption.parameters.get(0);
    }

    private int parseGlobalOption(List<GlobalOptionConfiguration> globalOptions, String[] programArgs, int offset) {
        int i = offset;
        String argument = programArgs[i++].substring(1);
        GlobalOptionConfiguration globalOption = new GlobalOptionConfiguration();
        globalOption.name = argument;
        globalOption.offset = offset;
        while (i < programArgs.length && this.isOptionParameter(programArgs[i])) {
            globalOption.parameters.add(programArgs[i++]);
        }
        globalOptions.add(globalOption);
        return i;
    }

    private int parseTask(String[] programArgs, int offset) {
        String arg;
        int i = offset;
        String taskType = programArgs[i++].substring(TASK_ARGUMENT_PREFIX.length());
        HashMap<String, String> taskArgs = new HashMap<String, String>();
        HashMap<String, String> pipeArgs = new HashMap<String, String>();
        String defaultArg = null;
        int defaultArgIndex = -1;
        while (i < programArgs.length && (arg = programArgs[i]).indexOf(TASK_ARGUMENT_PREFIX) != 0) {
            int equalsIndex = arg.indexOf("=");
            if (equalsIndex >= 0) {
                if (equalsIndex == 0) {
                    throw new OsmosisRuntimeException("Argument " + (i + 1) + " doesn't contain a name before the '=' (ie. name=value).");
                }
                if (equalsIndex >= arg.length() - 1) {
                    throw new OsmosisRuntimeException("Argument " + (i + 1) + " doesn't contain a value after the '=' (ie. name=value).");
                }
                String argName = arg.substring(0, equalsIndex);
                String argValue = arg.substring(equalsIndex + 1);
                if ("inPipe".equals(argName) || argName.indexOf("inPipe.") == 0 || "outPipe".equals(argName) || argName.indexOf("outPipe.") == 0) {
                    pipeArgs.put(argName, argValue);
                } else {
                    taskArgs.put(argName, argValue);
                }
            } else {
                if (defaultArgIndex >= 0) {
                    throw new OsmosisRuntimeException("Only one default (un-named) argument can exist per task.  Arguments " + (i + 1) + " and " + (defaultArgIndex + 1) + " have no name.");
                }
                defaultArg = arg;
                defaultArgIndex = i;
            }
            ++i;
        }
        String taskId = this.taskConfigList.size() + 1 + GLOBAL_ARGUMENT_PREFIX + taskType;
        this.taskConfigList.add(new TaskConfiguration(taskId, taskType, pipeArgs, taskArgs, defaultArg));
        return i;
    }

    public List<TaskConfiguration> getTaskInfoList() {
        return this.taskConfigList;
    }

    public int getLogLevelIndex() {
        return 3 + this.verboseValue - this.quietValue;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    private class GlobalOptionConfiguration {
        public String name;
        public List<String> parameters = new ArrayList<String>();
        public int offset;

        GlobalOptionConfiguration() {
        }
    }
}

