/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.osmosis;

import com.google.protobuf.ByteString;
import crosby.binary.BinarySerializer;
import crosby.binary.Osmformat;
import crosby.binary.StringTable;
import crosby.binary.file.BlockOutputStream;
import crosby.binary.file.FileBlock;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityProcessor;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainer;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainer;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.RelationMember;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.domain.v0_6.WayNode;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;

public class OsmosisSerializer
extends BinarySerializer
implements Sink {
    private static final Logger LOG = Logger.getLogger(OsmosisSerializer.class.getName());
    protected boolean useDense = true;
    protected boolean headerWritten = false;
    static int warncount = 0;
    private WayGroup ways;
    private NodeGroup nodes;
    private RelationGroup relations;
    private Processor processor = new Processor();

    public OsmosisSerializer(BlockOutputStream output) {
        super(output);
    }

    public void setUseDense(boolean useDense) {
        this.useDense = useDense;
    }

    private void switchTypes() {
        if (this.nodes != null) {
            this.groups.add(this.nodes);
            this.nodes = null;
        } else if (this.ways != null) {
            this.groups.add(this.ways);
            this.ways = null;
        } else if (this.relations != null) {
            this.groups.add(this.relations);
            this.relations = null;
        } else {
            return;
        }
    }

    private void processBounds(Bound entity) {
        Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
        Osmformat.HeaderBBox.Builder bbox = Osmformat.HeaderBBox.newBuilder();
        bbox.setLeft(this.mapRawDegrees(entity.getLeft()));
        bbox.setBottom(this.mapRawDegrees(entity.getBottom()));
        bbox.setRight(this.mapRawDegrees(entity.getRight()));
        bbox.setTop(this.mapRawDegrees(entity.getTop()));
        headerblock.setBbox(bbox);
        if (entity.getOrigin() != null) {
            headerblock.setSource(entity.getOrigin());
        }
        this.finishHeader(headerblock);
    }

    public void writeEmptyHeaderIfNeeded() {
        if (this.headerWritten) {
            return;
        }
        Osmformat.HeaderBlock.Builder headerblock = Osmformat.HeaderBlock.newBuilder();
        this.finishHeader(headerblock);
    }

    public void finishHeader(Osmformat.HeaderBlock.Builder headerblock) {
        headerblock.setWritingprogram("0.49.2");
        headerblock.addRequiredFeatures("OsmSchema-V0.6");
        if (this.useDense) {
            headerblock.addRequiredFeatures("DenseNodes");
        }
        Osmformat.HeaderBlock message = headerblock.build();
        try {
            this.output.write(FileBlock.newInstance((String)"OSMHeader", (ByteString)message.toByteString(), null));
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to write OSM header.", (Throwable)e);
        }
        this.headerWritten = true;
    }

    public void initialize(Map<String, Object> metaData) {
    }

    public void process(EntityContainer entityContainer) {
        entityContainer.process((EntityProcessor)this.processor);
    }

    public void complete() {
        try {
            this.switchTypes();
            this.processBatch();
            this.flush();
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to complete the PBF file.", (Throwable)e);
        }
    }

    public void close() {
        try {
            super.close();
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Unable to release PBF file resources during release.", e);
        }
    }

    public class Processor
    implements EntityProcessor {
        public void process(BoundContainer bound) {
            OsmosisSerializer.this.switchTypes();
            OsmosisSerializer.this.processBounds(bound.getEntity());
        }

        public void checkLimit() {
            OsmosisSerializer.this.total_entities++;
            if (++OsmosisSerializer.this.batch_size < OsmosisSerializer.this.batch_limit) {
                return;
            }
            OsmosisSerializer.this.switchTypes();
            OsmosisSerializer.this.processBatch();
        }

        public void process(NodeContainer node) {
            if (OsmosisSerializer.this.nodes == null) {
                OsmosisSerializer.this.writeEmptyHeaderIfNeeded();
                OsmosisSerializer.this.switchTypes();
                OsmosisSerializer.this.nodes = new NodeGroup();
            }
            OsmosisSerializer.this.nodes.add(node.getEntity());
            this.checkLimit();
        }

        public void process(WayContainer way) {
            if (OsmosisSerializer.this.ways == null) {
                OsmosisSerializer.this.writeEmptyHeaderIfNeeded();
                OsmosisSerializer.this.switchTypes();
                OsmosisSerializer.this.ways = new WayGroup();
            }
            OsmosisSerializer.this.ways.add(way.getEntity());
            this.checkLimit();
        }

        public void process(RelationContainer relation) {
            if (OsmosisSerializer.this.relations == null) {
                OsmosisSerializer.this.writeEmptyHeaderIfNeeded();
                OsmosisSerializer.this.switchTypes();
                OsmosisSerializer.this.relations = new RelationGroup();
            }
            OsmosisSerializer.this.relations.add(relation.getEntity());
            this.checkLimit();
        }
    }

    private class NodeGroup
    extends Prim<Node>
    implements BinarySerializer.PrimGroupWriterInterface {
        private NodeGroup() {
        }

        public Osmformat.PrimitiveGroup serialize() {
            if (OsmosisSerializer.this.useDense) {
                return this.serializeDense();
            }
            return this.serializeNonDense();
        }

        public Osmformat.PrimitiveGroup serializeDense() {
            if (this.contents.size() == 0) {
                return null;
            }
            Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
            StringTable stable = OsmosisSerializer.this.getStringTable();
            long lastlat = 0L;
            long lastlon = 0L;
            long lastid = 0L;
            Osmformat.DenseNodes.Builder bi = Osmformat.DenseNodes.newBuilder();
            boolean doesBlockHaveTags = false;
            for (Node i : this.contents) {
                doesBlockHaveTags = doesBlockHaveTags || !i.getTags().isEmpty();
            }
            if (!OsmosisSerializer.this.omit_metadata) {
                Osmformat.DenseInfo.Builder bdi = Osmformat.DenseInfo.newBuilder();
                this.serializeMetadataDense(bdi, this.contents);
                bi.setDenseinfo(bdi);
            }
            for (Node i : this.contents) {
                long id = i.getId();
                int lat = OsmosisSerializer.this.mapDegrees(i.getLatitude());
                int lon = OsmosisSerializer.this.mapDegrees(i.getLongitude());
                bi.addId(id - lastid);
                lastid = id;
                bi.addLon((long)lon - lastlon);
                lastlon = lon;
                bi.addLat((long)lat - lastlat);
                lastlat = lat;
                if (!doesBlockHaveTags) continue;
                for (Tag t : i.getTags()) {
                    bi.addKeysVals(stable.getIndex(t.getKey()));
                    bi.addKeysVals(stable.getIndex(t.getValue()));
                }
                bi.addKeysVals(0);
            }
            builder.setDense(bi);
            return builder.build();
        }

        public Osmformat.PrimitiveGroup serializeNonDense() {
            if (this.contents.size() == 0) {
                return null;
            }
            StringTable stable = OsmosisSerializer.this.getStringTable();
            Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
            for (Node i : this.contents) {
                long id = i.getId();
                int lat = OsmosisSerializer.this.mapDegrees(i.getLatitude());
                int lon = OsmosisSerializer.this.mapDegrees(i.getLongitude());
                Osmformat.Node.Builder bi = Osmformat.Node.newBuilder();
                bi.setId(id);
                bi.setLon((long)lon);
                bi.setLat((long)lat);
                for (Tag t : i.getTags()) {
                    bi.addKeys(stable.getIndex(t.getKey()));
                    bi.addVals(stable.getIndex(t.getValue()));
                }
                if (!OsmosisSerializer.this.omit_metadata) {
                    bi.setInfo(this.serializeMetadata((Entity)i));
                }
                builder.addNodes(bi);
            }
            return builder.build();
        }
    }

    private class WayGroup
    extends Prim<Way>
    implements BinarySerializer.PrimGroupWriterInterface {
        private WayGroup() {
        }

        public Osmformat.PrimitiveGroup serialize() {
            if (this.contents.size() == 0) {
                return null;
            }
            StringTable stable = OsmosisSerializer.this.getStringTable();
            Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
            for (Way i : this.contents) {
                Osmformat.Way.Builder bi = Osmformat.Way.newBuilder();
                bi.setId(i.getId());
                long lastid = 0L;
                for (WayNode j : i.getWayNodes()) {
                    long id = j.getNodeId();
                    bi.addRefs(id - lastid);
                    lastid = id;
                }
                for (Tag t : i.getTags()) {
                    bi.addKeys(stable.getIndex(t.getKey()));
                    bi.addVals(stable.getIndex(t.getValue()));
                }
                if (!OsmosisSerializer.this.omit_metadata) {
                    bi.setInfo(this.serializeMetadata((Entity)i));
                }
                builder.addWays(bi);
            }
            return builder.build();
        }
    }

    private class RelationGroup
    extends Prim<Relation>
    implements BinarySerializer.PrimGroupWriterInterface {
        private RelationGroup() {
        }

        @Override
        public void addStringsToStringtable() {
            StringTable stable = OsmosisSerializer.this.getStringTable();
            super.addStringsToStringtable();
            for (Relation i : this.contents) {
                for (RelationMember j : i.getMembers()) {
                    stable.incr(j.getMemberRole());
                }
            }
        }

        public Osmformat.PrimitiveGroup serialize() {
            if (this.contents.size() == 0) {
                return null;
            }
            StringTable stable = OsmosisSerializer.this.getStringTable();
            Osmformat.PrimitiveGroup.Builder builder = Osmformat.PrimitiveGroup.newBuilder();
            for (Relation i : this.contents) {
                Osmformat.Relation.Builder bi = Osmformat.Relation.newBuilder();
                bi.setId(i.getId());
                RelationMember[] arr = new RelationMember[i.getMembers().size()];
                i.getMembers().toArray(arr);
                long lastid = 0L;
                for (RelationMember j : i.getMembers()) {
                    long id = j.getMemberId();
                    bi.addMemids(id - lastid);
                    lastid = id;
                    if (j.getMemberType() == EntityType.Node) {
                        bi.addTypes(Osmformat.Relation.MemberType.NODE);
                    } else if (j.getMemberType() == EntityType.Way) {
                        bi.addTypes(Osmformat.Relation.MemberType.WAY);
                    } else if (j.getMemberType() == EntityType.Relation) {
                        bi.addTypes(Osmformat.Relation.MemberType.RELATION);
                    } else assert (false);
                    bi.addRolesSid(stable.getIndex(j.getMemberRole()));
                }
                for (Tag t : i.getTags()) {
                    bi.addKeys(stable.getIndex(t.getKey()));
                    bi.addVals(stable.getIndex(t.getValue()));
                }
                if (!OsmosisSerializer.this.omit_metadata) {
                    bi.setInfo(this.serializeMetadata((Entity)i));
                }
                builder.addRelations(bi);
            }
            return builder.build();
        }
    }

    private abstract class Prim<T extends Entity> {
        ArrayList<T> contents = new ArrayList();
        private static final int MAXWARN = 100;

        private Prim() {
        }

        public void add(T item) {
            this.contents.add(item);
        }

        public void addStringsToStringtable() {
            StringTable stable = OsmosisSerializer.this.getStringTable();
            for (Entity i : this.contents) {
                Collection tags = i.getTags();
                for (Tag tag : tags) {
                    stable.incr(tag.getKey());
                    stable.incr(tag.getValue());
                }
                if (OsmosisSerializer.this.omit_metadata) continue;
                stable.incr(i.getUser().getName());
            }
        }

        public void serializeMetadataDense(Osmformat.DenseInfo.Builder b, List<? extends Entity> entities) {
            if (OsmosisSerializer.this.omit_metadata) {
                return;
            }
            long lasttimestamp = 0L;
            long lastchangeset = 0L;
            int lastuserSid = 0;
            int lastuid = 0;
            StringTable stable = OsmosisSerializer.this.getStringTable();
            for (Entity entity : entities) {
                if (entity.getUser() == OsmUser.NONE && warncount < 100) {
                    LOG.warning("Attention: Data being output lacks metadata. Please use omitmetadata=true");
                    ++warncount;
                }
                int uid = entity.getUser().getId();
                int userSid = stable.getIndex(entity.getUser().getName());
                int timestamp = (int)(entity.getTimestamp().getTime() / (long)OsmosisSerializer.this.date_granularity);
                int version = entity.getVersion();
                long changeset = entity.getChangesetId();
                b.addVersion(version);
                b.addTimestamp((long)timestamp - lasttimestamp);
                lasttimestamp = timestamp;
                b.addChangeset(changeset - lastchangeset);
                lastchangeset = changeset;
                b.addUid(uid - lastuid);
                lastuid = uid;
                b.addUserSid(userSid - lastuserSid);
                lastuserSid = userSid;
            }
        }

        public Osmformat.Info.Builder serializeMetadata(Entity e) {
            StringTable stable = OsmosisSerializer.this.getStringTable();
            Osmformat.Info.Builder b = Osmformat.Info.newBuilder();
            if (!OsmosisSerializer.this.omit_metadata) {
                if (e.getUser() == OsmUser.NONE && warncount < 100) {
                    LOG.warning("Attention: Data being output lacks metadata. Please use omitmetadata=true");
                    ++warncount;
                }
                if (e.getUser() != OsmUser.NONE) {
                    b.setUid(e.getUser().getId());
                    b.setUserSid(stable.getIndex(e.getUser().getName()));
                }
                b.setTimestamp((long)((int)(e.getTimestamp().getTime() / (long)OsmosisSerializer.this.date_granularity)));
                b.setVersion(e.getVersion());
                b.setChangeset(e.getChangesetId());
            }
            return b;
        }
    }
}

