/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pbf2.v0_6;

import com.google.common.util.concurrent.MoreExecutors;
import crosby.binary.Osmformat;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.task.v0_6.RunnableSource;
import org.openstreetmap.osmosis.core.task.v0_6.Sink;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.HeaderBoundReader;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.HeaderMetadataReader;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.HeaderSeeker;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.PbfDecoder;
import org.openstreetmap.osmosis.pbf2.v0_6.impl.StreamSplitter;

public class PbfReader
implements RunnableSource {
    private final Supplier<InputStream> supplier;
    private Sink sink;
    private int workers;

    public PbfReader(File file, int workers) {
        this(() -> {
            if (file.getName().equals("-")) {
                return System.in;
            }
            try {
                return new FileInputStream(file);
            }
            catch (IOException e) {
                throw new OsmosisRuntimeException("Unable to read PBF file " + file + ".", (Throwable)e);
            }
        }, workers);
    }

    public PbfReader(Supplier<InputStream> supplier, int workers) {
        this.supplier = supplier;
        this.workers = workers;
    }

    public void setSink(Sink sink) {
        this.sink = sink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        StreamSplitter streamSplitter = null;
        ExecutorService executorService = this.workers > 0 ? Executors.newFixedThreadPool(this.workers) : MoreExecutors.newDirectExecutorService();
        try {
            InputStream inputStream = this.supplier.get();
            streamSplitter = new StreamSplitter(new DataInputStream(inputStream));
            Osmformat.HeaderBlock header = new HeaderSeeker().apply(streamSplitter);
            Map<String, Object> metadata = new HeaderMetadataReader().apply(header);
            this.sink.initialize(metadata);
            BoundContainer bound = new HeaderBoundReader().apply(header);
            this.sink.process((EntityContainer)bound);
            PbfDecoder pbfDecoder = new PbfDecoder(streamSplitter, executorService, this.workers + 1, this.sink);
            pbfDecoder.run();
            this.sink.complete();
        }
        finally {
            this.sink.close();
            executorService.shutdownNow();
            if (streamSplitter != null) {
                streamSplitter.close();
            }
        }
    }
}

