/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.file;

import crosby.binary.file.CompressFlags;
import crosby.binary.file.FileBlock;
import crosby.binary.file.FileBlockPosition;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class BlockOutputStream
implements Closeable,
Flushable {
    OutputStream outwrite;
    List<FileBlockPosition> writtenblocks = new ArrayList<FileBlockPosition>();
    CompressFlags compression;

    public BlockOutputStream(OutputStream output) {
        this.outwrite = new DataOutputStream(output);
        this.compression = CompressFlags.DEFLATE;
    }

    public void setCompress(CompressFlags flag) {
        this.compression = flag;
    }

    public void setCompress(String s) {
        if (s.equals("none")) {
            this.compression = CompressFlags.NONE;
        } else if (s.equals("deflate")) {
            this.compression = CompressFlags.DEFLATE;
        } else {
            throw new IllegalArgumentException("Unknown compression type: " + s);
        }
    }

    public void write(FileBlock block) throws IOException {
        this.write(block, this.compression);
    }

    public void write(FileBlock block, CompressFlags compression) throws IOException {
        FileBlockPosition ref = block.writeTo(this.outwrite, compression);
        this.writtenblocks.add(ref);
    }

    @Override
    public void flush() throws IOException {
        this.outwrite.flush();
    }

    @Override
    public void close() throws IOException {
        this.outwrite.flush();
        this.outwrite.close();
    }
}

