/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary;

import com.google.protobuf.ByteString;
import crosby.binary.Osmformat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class StringTable {
    private HashMap<String, Integer> counts;
    private HashMap<String, Integer> stringmap;
    private String[] set;

    public StringTable() {
        this.clear();
    }

    public void incr(String s) {
        this.counts.merge(s, 1, Integer::sum);
    }

    public int getIndex(String s) {
        return this.stringmap.get(s);
    }

    public void finish() {
        Comparator comparator = (s1, s2) -> this.counts.get(s2) - this.counts.get(s1);
        this.set = this.counts.keySet().toArray(new String[0]);
        if (this.set.length > 0) {
            Arrays.sort(this.set, comparator);
            Arrays.sort(this.set, Math.min(128, this.set.length - 1), Math.min(16384, this.set.length - 1));
            Arrays.sort(this.set, Math.min(16384, this.set.length - 1), Math.min(0x200000, this.set.length - 1), comparator);
        }
        this.stringmap = new HashMap(2 * this.set.length);
        for (int i = 0; i < this.set.length; ++i) {
            this.stringmap.put(this.set[i], i + 1);
        }
        this.counts = null;
    }

    public void clear() {
        this.counts = new HashMap(100);
        this.stringmap = null;
        this.set = null;
    }

    public Osmformat.StringTable.Builder serialize() {
        Osmformat.StringTable.Builder builder = Osmformat.StringTable.newBuilder();
        builder.addS(ByteString.copyFromUtf8((String)""));
        for (String s : this.set) {
            builder.addS(ByteString.copyFromUtf8((String)s));
        }
        return builder;
    }
}

