/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.geometry.Geometry;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityMapper;

public class WayMapper
extends EntityMapper<Way> {
    private boolean supportBboxColumn;
    private boolean supportLinestringColumn;

    public WayMapper() {
        this.supportBboxColumn = false;
    }

    public WayMapper(boolean supportBboxColumn, boolean supportLinestringColumn) {
        this.supportBboxColumn = supportBboxColumn;
        this.supportLinestringColumn = supportLinestringColumn;
    }

    @Override
    public String getEntityName() {
        return "way";
    }

    @Override
    public ActionDataType getEntityType() {
        return ActionDataType.WAY;
    }

    @Override
    public Class<Way> getEntityClass() {
        return Way.class;
    }

    @Override
    protected String[] getTypeSpecificFieldNames() {
        ArrayList<String> fieldNames = new ArrayList<String>();
        if (this.supportBboxColumn) {
            fieldNames.add("bbox");
        }
        if (this.supportLinestringColumn) {
            fieldNames.add("linestring");
        }
        return fieldNames.toArray(new String[0]);
    }

    @Override
    public Way parseRecord(ResultSet resultSet) {
        try {
            return new Way(new CommonEntityData(resultSet.getLong("id"), resultSet.getInt("version"), new Date(resultSet.getTimestamp("tstamp").getTime()), this.buildUser(resultSet), resultSet.getLong("changeset_id")));
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to build a way from the current recordset row.", (Throwable)e);
        }
    }

    @Override
    public int populateEntityParameters(PreparedStatement statement, int initialIndex, Way way) {
        return this.populateCommonEntityParameters(statement, initialIndex, (Entity)way);
    }

    public int populateEntityParameters(PreparedStatement statement, int initialIndex, Way way, List<Geometry> geometries) {
        int prmIndex = this.populateEntityParameters(statement, initialIndex, way);
        try {
            for (int i = 0; i < geometries.size(); ++i) {
                statement.setObject(prmIndex++, new PGgeometry(geometries.get(i)));
            }
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to set the bbox for way " + way.getId() + ".", (Throwable)e);
        }
        return prmIndex;
    }
}

