/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.osmosis.core.container.v0_6.EntityManager;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.OsmUser;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.pgsimple.common.NoSuchRecordException;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.EntityDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.UserDao;

public class PostgreSqlEntityManager<T extends Entity>
implements EntityManager<T> {
    private EntityDao<T> entityDao;
    private UserDao userDao;
    private Set<Integer> userSet;

    public PostgreSqlEntityManager(EntityDao<T> entityDao, UserDao userDao) {
        this.entityDao = entityDao;
        this.userDao = userDao;
        this.userSet = new HashSet<Integer>();
    }

    private void writeUser(OsmUser user) {
        if (!OsmUser.NONE.equals((Object)user) && !this.userSet.contains(user.getId())) {
            int userId = user.getId();
            try {
                OsmUser existingUser = this.userDao.getUser(userId);
                if (!user.equals((Object)existingUser)) {
                    this.userDao.updateUser(user);
                }
            }
            catch (NoSuchRecordException e) {
                this.userDao.addUser(user);
            }
            this.userSet.add(user.getId());
        }
    }

    public void addEntity(T entity) {
        this.writeUser(entity.getUser());
        this.entityDao.addEntity(entity);
    }

    public boolean exists(long id) {
        return this.entityDao.exists(id);
    }

    public T getEntity(long id) {
        return this.entityDao.getEntity(id);
    }

    public ReleasableIterator<T> iterate() {
        return this.entityDao.iterate();
    }

    public void modifyEntity(T entity) {
        this.writeUser(entity.getUser());
        this.entityDao.modifyEntity(entity);
    }

    public void removeEntity(long entityId) {
        this.entityDao.removeEntity(entityId);
    }
}

