/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.postgis.jdbc.PGgeometry;
import net.postgis.jdbc.geometry.Geometry;
import net.postgis.jdbc.geometry.Point;
import net.postgis.jdbc.geometry.Polygon;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.container.v0_6.BoundContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.DatasetContext;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityManager;
import org.openstreetmap.osmosis.core.container.v0_6.NodeContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.RelationContainerIterator;
import org.openstreetmap.osmosis.core.container.v0_6.WayContainerIterator;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.core.domain.v0_6.Bound;
import org.openstreetmap.osmosis.core.domain.v0_6.EntityType;
import org.openstreetmap.osmosis.core.domain.v0_6.Node;
import org.openstreetmap.osmosis.core.domain.v0_6.Relation;
import org.openstreetmap.osmosis.core.domain.v0_6.Way;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.store.MultipleSourceIterator;
import org.openstreetmap.osmosis.core.store.ReleasableAdaptorForIterator;
import org.openstreetmap.osmosis.core.store.UpcastIterator;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.common.PolygonBuilder;
import org.openstreetmap.osmosis.pgsimple.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.DatabaseCapabilityChecker;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.MemberTypeValueMapper;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.NodeDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.NodeReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.PostgreSqlEntityManager;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.RelationReader;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.UserDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayDao;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.WayReader;

public class PostgreSqlDatasetContext
implements DatasetContext {
    private static final Logger LOG = Logger.getLogger(PostgreSqlDatasetContext.class.getName());
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private DatabaseCapabilityChecker capabilityChecker;
    private boolean initialized;
    private DatabaseContext dbCtx;
    private UserDao userDao;
    private NodeDao nodeDao;
    private WayDao wayDao;
    private RelationDao relationDao;
    private PostgreSqlEntityManager<Node> nodeManager;
    private PostgreSqlEntityManager<Way> wayManager;
    private PostgreSqlEntityManager<Relation> relationManager;
    private PolygonBuilder polygonBuilder;
    private ReleasableContainer releasableContainer;

    public PostgreSqlDatasetContext(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.polygonBuilder = new PolygonBuilder();
        this.releasableContainer = new ReleasableContainer();
        this.initialized = false;
    }

    private void initialize() {
        if (this.dbCtx == null) {
            this.dbCtx = new DatabaseContext(this.loginCredentials);
            new SchemaVersionValidator(this.dbCtx, this.preferences).validateVersion(5);
            this.capabilityChecker = new DatabaseCapabilityChecker(this.dbCtx);
            ActionDao actionDao = (ActionDao)this.releasableContainer.add((Closeable)new ActionDao(this.dbCtx));
            this.userDao = (UserDao)this.releasableContainer.add((Closeable)new UserDao(this.dbCtx, actionDao));
            this.nodeDao = (NodeDao)this.releasableContainer.add((Closeable)new NodeDao(this.dbCtx, actionDao));
            this.wayDao = (WayDao)this.releasableContainer.add((Closeable)new WayDao(this.dbCtx, actionDao));
            this.relationDao = (RelationDao)this.releasableContainer.add((Closeable)new RelationDao(this.dbCtx, actionDao));
            this.nodeManager = new PostgreSqlEntityManager<Node>(this.nodeDao, this.userDao);
            this.wayManager = new PostgreSqlEntityManager<Way>(this.wayDao, this.userDao);
            this.relationManager = new PostgreSqlEntityManager<Relation>(this.relationDao, this.userDao);
        }
        this.initialized = true;
    }

    @Deprecated
    public Node getNode(long id) {
        return (Node)this.getNodeManager().getEntity(id);
    }

    @Deprecated
    public Way getWay(long id) {
        return (Way)this.getWayManager().getEntity(id);
    }

    @Deprecated
    public Relation getRelation(long id) {
        return (Relation)this.getRelationManager().getEntity(id);
    }

    public EntityManager<Node> getNodeManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.nodeManager;
    }

    public EntityManager<Way> getWayManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.wayManager;
    }

    public EntityManager<Relation> getRelationManager() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.relationManager;
    }

    public ReleasableIterator<EntityContainer> iterate() {
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        bounds.add(new Bound("Osmosis 0.49.2"));
        ArrayList<UpcastIterator> sources = new ArrayList<UpcastIterator>();
        sources.add(new UpcastIterator((ReleasableIterator)new BoundContainerIterator((ReleasableIterator)new ReleasableAdaptorForIterator(bounds.iterator()))));
        sources.add(new UpcastIterator((ReleasableIterator)new NodeContainerIterator(this.nodeDao.iterate())));
        sources.add(new UpcastIterator((ReleasableIterator)new WayContainerIterator(this.wayDao.iterate())));
        sources.add(new UpcastIterator((ReleasableIterator)new RelationContainerIterator(this.relationDao.iterate())));
        return new MultipleSourceIterator(sources);
    }

    public ReleasableIterator<EntityContainer> iterateBoundingBox(double left, double right, double top, double bottom, boolean completeWays) {
        Statement preparedStatement = null;
        if (!this.initialized) {
            this.initialize();
        }
        ArrayList<Bound> bounds = new ArrayList<Bound>();
        bounds.add(new Bound(right, left, top, bottom, "Osmosis 0.49.2"));
        try {
            this.dbCtx.executeStatement("SET enable_seqscan = false");
            this.dbCtx.executeStatement("SET enable_mergejoin = false");
            this.dbCtx.executeStatement("SET enable_hashjoin = false");
            LOG.finer("Creating node id temp table.");
            this.dbCtx.executeStatement("CREATE TEMPORARY TABLE box_node_list (id bigint PRIMARY KEY) ON COMMIT DROP");
            LOG.finer("Creating way id temp table.");
            this.dbCtx.executeStatement("CREATE TEMPORARY TABLE box_way_list (id bigint PRIMARY KEY) ON COMMIT DROP");
            LOG.finer("Creating relation id temp table.");
            this.dbCtx.executeStatement("CREATE TEMPORARY TABLE box_relation_list (id bigint PRIMARY KEY) ON COMMIT DROP");
            Point[] bboxPoints = new Point[]{new Point(left, bottom), new Point(left, top), new Point(right, top), new Point(right, bottom), new Point(left, bottom)};
            Polygon bboxPolygon = this.polygonBuilder.createPolygon(bboxPoints);
            MemberTypeValueMapper memberTypeValueMapper = new MemberTypeValueMapper();
            LOG.finer("Selecting all node ids inside bounding box.");
            preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_node_list SELECT id FROM nodes WHERE (geom && ?)");
            int prmIndex = 1;
            preparedStatement.setObject(prmIndex++, new PGgeometry((Geometry)bboxPolygon));
            int rowCount = preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            LOG.finer(rowCount + " rows affected.");
            if (this.capabilityChecker.isWayLinestringSupported()) {
                LOG.finer("Selecting all way ids inside bounding box using way linestring geometry.");
                preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_way_list SELECT id FROM ways w where w.linestring && ?");
                prmIndex = 1;
                preparedStatement.setObject(prmIndex++, new PGgeometry((Geometry)bboxPolygon));
            } else if (this.capabilityChecker.isWayBboxSupported()) {
                LOG.finer("Selecting all way ids inside bounding box using dynamically built way linestring with way bbox indexing.");
                preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_way_list SELECT way_id FROM (SELECT c.way_id AS way_id, ST_MakeLine(c.geom) AS way_line FROM (SELECT w.id AS way_id, n.geom AS geom FROM nodes n INNER JOIN way_nodes wn ON n.id = wn.node_id INNER JOIN ways w ON wn.way_id = w.id WHERE (w.bbox && ?) ORDER BY wn.way_id, wn.sequence_id) c GROUP BY c.way_id) w WHERE (w.way_line && ?)");
                prmIndex = 1;
                preparedStatement.setObject(prmIndex++, new PGgeometry((Geometry)bboxPolygon));
                preparedStatement.setObject(prmIndex++, new PGgeometry((Geometry)bboxPolygon));
            } else {
                LOG.finer("Selecting all way ids inside bounding box using already selected nodes.");
                preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_way_list SELECT wn.way_id FROM way_nodes wn INNER JOIN box_node_list n ON wn.node_id = n.id GROUP BY wn.way_id");
            }
            rowCount = preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            LOG.finer(rowCount + " rows affected.");
            LOG.finer("Selecting all relation ids containing selected nodes or ways.");
            preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_relation_list (SELECT rm.relation_id AS relation_id FROM relation_members rm INNER JOIN box_node_list n ON rm.member_id = n.id WHERE rm.member_type = ? UNION SELECT rm.relation_id AS relation_id FROM relation_members rm INNER JOIN box_way_list w ON rm.member_id = w.id WHERE rm.member_type = ?)");
            prmIndex = 1;
            preparedStatement.setString(prmIndex++, memberTypeValueMapper.getMemberType(EntityType.Node));
            preparedStatement.setString(prmIndex++, memberTypeValueMapper.getMemberType(EntityType.Way));
            rowCount = preparedStatement.executeUpdate();
            preparedStatement.close();
            preparedStatement = null;
            LOG.finer(rowCount + " rows affected.");
            do {
                LOG.finer("Selecting parent relations of selected relations.");
                preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_relation_list SELECT rm.relation_id AS relation_id FROM relation_members rm INNER JOIN box_relation_list r ON rm.member_id = r.id WHERE rm.member_type = ? EXCEPT SELECT id AS relation_id FROM box_relation_list");
                prmIndex = 1;
                preparedStatement.setString(prmIndex++, memberTypeValueMapper.getMemberType(EntityType.Relation));
                rowCount = preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = null;
                LOG.finer(rowCount + " rows affected.");
            } while (rowCount > 0);
            if (completeWays) {
                LOG.finer("Selecting all node ids for selected ways.");
                preparedStatement = this.dbCtx.prepareStatement("INSERT INTO box_node_list SELECT wn.node_id AS id FROM way_nodes wn INNER JOIN box_way_list bw ON wn.way_id = bw.id EXCEPT SELECT id AS node_id FROM box_node_list");
                prmIndex = 1;
                rowCount = preparedStatement.executeUpdate();
                preparedStatement.close();
                preparedStatement = null;
                LOG.finer(rowCount + " rows affected.");
            }
            this.dbCtx.executeStatement("ANALYZE box_node_list");
            this.dbCtx.executeStatement("ANALYZE box_way_list");
            this.dbCtx.executeStatement("ANALYZE box_relation_list");
            LOG.finer("Iterating over results.");
            ArrayList<UpcastIterator> resultSets = new ArrayList<UpcastIterator>();
            resultSets.add(new UpcastIterator((ReleasableIterator)new BoundContainerIterator((ReleasableIterator)new ReleasableAdaptorForIterator(bounds.iterator()))));
            resultSets.add(new UpcastIterator((ReleasableIterator)new NodeContainerIterator((ReleasableIterator)new NodeReader(this.dbCtx, "box_node_list"))));
            resultSets.add(new UpcastIterator((ReleasableIterator)new WayContainerIterator((ReleasableIterator)new WayReader(this.dbCtx, "box_way_list"))));
            resultSets.add(new UpcastIterator((ReleasableIterator)new RelationContainerIterator((ReleasableIterator)new RelationReader(this.dbCtx, "box_relation_list"))));
            MultipleSourceIterator multipleSourceIterator = new MultipleSourceIterator(resultSets);
            return multipleSourceIterator;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to perform bounding box queries.", (Throwable)e);
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    LOG.log(Level.WARNING, "Unable to close prepared statement.", e);
                }
            }
        }
    }

    public void complete() {
        if (this.dbCtx != null) {
            this.dbCtx.commit();
        }
    }

    public void close() {
        this.releasableContainer.close();
        this.releasableContainer.clear();
        if (this.dbCtx != null) {
            this.dbCtx.close();
            this.dbCtx = null;
        }
    }
}

