/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;
import org.openstreetmap.osmosis.core.database.DatabasePreferences;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.common.SchemaVersionValidator;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.CopyFileset;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.IndexManager;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;

public class CopyFilesetLoader
implements Runnable {
    private static final Logger LOG = Logger.getLogger(CopyFilesetLoader.class.getName());
    private DatabaseLoginCredentials loginCredentials;
    private DatabasePreferences preferences;
    private CopyFileset copyFileset;

    public CopyFilesetLoader(DatabaseLoginCredentials loginCredentials, DatabasePreferences preferences, CopyFileset copyFileset) {
        this.loginCredentials = loginCredentials;
        this.preferences = preferences;
        this.copyFileset = copyFileset;
    }

    public void loadCopyFile(DatabaseContext dbCtx, File copyFile, String tableName) {
        try (BufferedInputStream bufferedInStream = new BufferedInputStream(new FileInputStream(copyFile), 65536);){
            CopyManager copyManager = new CopyManager((BaseConnection)dbCtx.getConnection());
            copyManager.copyIn("COPY " + tableName + " FROM STDIN", (InputStream)bufferedInStream);
        }
        catch (IOException e) {
            throw new OsmosisRuntimeException("Unable to process COPY file " + copyFile + ".", (Throwable)e);
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to process COPY file " + copyFile + ".", (Throwable)e);
        }
    }

    @Override
    public void run() {
        try (DatabaseContext dbCtx = new DatabaseContext(this.loginCredentials);){
            new SchemaVersionValidator(dbCtx, this.preferences).validateVersion(5);
            IndexManager indexManager = new IndexManager(dbCtx, false, false);
            indexManager.prepareForLoad();
            LOG.finer("Loading users.");
            this.loadCopyFile(dbCtx, this.copyFileset.getUserFile(), "users");
            LOG.finer("Loading nodes.");
            this.loadCopyFile(dbCtx, this.copyFileset.getNodeFile(), "nodes");
            LOG.finer("Loading node tags.");
            this.loadCopyFile(dbCtx, this.copyFileset.getNodeTagFile(), "node_tags");
            LOG.finer("Loading ways.");
            this.loadCopyFile(dbCtx, this.copyFileset.getWayFile(), "ways");
            LOG.finer("Loading way tags.");
            this.loadCopyFile(dbCtx, this.copyFileset.getWayTagFile(), "way_tags");
            LOG.finer("Loading way nodes.");
            this.loadCopyFile(dbCtx, this.copyFileset.getWayNodeFile(), "way_nodes");
            LOG.finer("Loading relations.");
            this.loadCopyFile(dbCtx, this.copyFileset.getRelationFile(), "relations");
            LOG.finer("Loading relation tags.");
            this.loadCopyFile(dbCtx, this.copyFileset.getRelationTagFile(), "relation_tags");
            LOG.finer("Loading relation members.");
            this.loadCopyFile(dbCtx, this.copyFileset.getRelationMemberFile(), "relation_members");
            LOG.finer("Committing changes.");
            LOG.fine("Data load complete.");
            indexManager.completeAfterLoad();
            LOG.fine("Committing changes.");
            dbCtx.commit();
            LOG.fine("Vacuuming database.");
            dbCtx.setAutoCommit(true);
            dbCtx.executeStatement("VACUUM ANALYZE");
            LOG.fine("Complete.");
        }
    }
}

