/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.v0_6.impl;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.pgsimple.common.BaseDao;
import org.openstreetmap.osmosis.pgsimple.common.DatabaseContext;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ActionDataType;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.ChangesetAction;
import org.openstreetmap.osmosis.pgsimple.v0_6.impl.DatabaseCapabilityChecker;

public class ActionDao
extends BaseDao {
    private static final String SQL_INSERT = "INSERT INTO actions(data_type, action, id) VALUES(?, ?, ?)";
    private static final String SQL_TRUNCATE = "TRUNCATE actions";
    private boolean enabled;
    private DatabaseCapabilityChecker capabilityChecker;
    private PreparedStatement insertStatement;
    private PreparedStatement truncateStatement;

    public ActionDao(DatabaseContext dbCtx) {
        this(dbCtx, true);
        this.capabilityChecker = new DatabaseCapabilityChecker(dbCtx);
    }

    public ActionDao(DatabaseContext dbCtx, boolean enabled) {
        super(dbCtx);
        this.enabled = enabled;
    }

    public void addAction(ActionDataType dataType, ChangesetAction action, long id) {
        if (this.enabled && this.capabilityChecker.isActionSupported()) {
            if (this.insertStatement == null) {
                this.insertStatement = this.prepareStatement(SQL_INSERT);
            }
            int prmIndex = 1;
            try {
                this.insertStatement.setString(prmIndex++, dataType.getDatabaseValue());
                this.insertStatement.setString(prmIndex++, action.getDatabaseValue());
                this.insertStatement.setLong(prmIndex++, id);
                this.insertStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to insert action with type=" + dataType + ", action=" + action + " and id=" + id + ".", (Throwable)e);
            }
        }
    }

    public void truncate() {
        if (this.enabled && this.capabilityChecker.isActionSupported()) {
            if (this.truncateStatement == null) {
                this.truncateStatement = this.prepareStatement(SQL_TRUNCATE);
            }
            try {
                this.truncateStatement.executeUpdate();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Truncate failed for actions.", (Throwable)e);
            }
        }
    }
}

