/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.pgsimple.common;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.openstreetmap.osmosis.core.OsmosisRuntimeException;
import org.openstreetmap.osmosis.core.database.DatabaseLoginCredentials;

public class DatabaseContext
implements AutoCloseable {
    private static final Logger LOG = Logger.getLogger(DatabaseContext.class.getName());
    private DatabaseLoginCredentials loginCredentials;
    private Connection connection;
    private boolean autoCommit;
    private Statement statement;

    public DatabaseContext(DatabaseLoginCredentials loginCredentials) {
        this.loginCredentials = loginCredentials;
        this.autoCommit = false;
    }

    private Connection getConnectionFromDriverManager() {
        try {
            return DriverManager.getConnection("jdbc:postgresql://" + this.loginCredentials.getHost() + "/" + this.loginCredentials.getDatabase(), this.loginCredentials.getUser(), this.loginCredentials.getPassword());
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to establish a new database connection.", (Throwable)e);
        }
    }

    private Connection getConnectionFromDatasource() {
        DataSource ds;
        InitialContext cxt;
        String jndiLocation = this.loginCredentials.getDatasourceJndiLocation();
        try {
            cxt = new InitialContext();
        }
        catch (NamingException e) {
            throw new OsmosisRuntimeException("Unable to create an initial JNDI context.", (Throwable)e);
        }
        try {
            ds = (DataSource)cxt.lookup(jndiLocation);
        }
        catch (NamingException e) {
            throw new OsmosisRuntimeException("Unable to locate the datasource (" + jndiLocation + ")", (Throwable)e);
        }
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to obtain a connection from the datasource.", (Throwable)e);
        }
    }

    public Connection getConnection() {
        if (this.connection == null) {
            String jndiLocation = this.loginCredentials.getDatasourceJndiLocation();
            if (jndiLocation != null) {
                LOG.finer("Creating a new database connection from JNDI.");
                this.connection = this.getConnectionFromDatasource();
            } else {
                LOG.finer("Creating a new database connection using DriverManager.");
                this.connection = this.getConnectionFromDriverManager();
            }
            try {
                this.connection.setAutoCommit(this.autoCommit);
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to set auto commit to " + this.autoCommit + ".", (Throwable)e);
            }
        }
        return this.connection;
    }

    public void executeStatement(String sql) {
        try {
            LOG.finest("Executing statement {" + sql + "}");
            if (this.statement != null) {
                this.statement.close();
            }
            this.statement = this.getConnection().createStatement();
            this.statement.execute(sql);
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to execute statement.", (Throwable)e);
        }
    }

    public PreparedStatement prepareStatement(String sql) {
        try {
            LOG.finest("Creating prepared statement {" + sql + "}");
            PreparedStatement preparedStatement = this.getConnection().prepareStatement(sql);
            return preparedStatement;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to create database prepared statement.", (Throwable)e);
        }
    }

    public CallableStatement prepareCall(String sql) {
        try {
            LOG.finest("Creating callable statement {" + sql + "}");
            CallableStatement callableStatement = this.getConnection().prepareCall(sql);
            return callableStatement;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to create database callable statement.", (Throwable)e);
        }
    }

    public Statement createStatement() {
        try {
            LOG.finest("Creating a new statement.");
            Statement resultStatement = this.getConnection().createStatement();
            return resultStatement;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to create database statement.", (Throwable)e);
        }
    }

    public ResultSet executeQuery(String sql) {
        try {
            LOG.finest("Executing query {" + sql + "}");
            if (this.statement != null) {
                this.statement.close();
            }
            this.statement = this.getConnection().createStatement(1003, 1007);
            this.statement.setFetchSize(10000);
            ResultSet resultSet = this.statement.executeQuery(sql);
            return resultSet;
        }
        catch (SQLException e) {
            throw new OsmosisRuntimeException("Unable to create resultset.", (Throwable)e);
        }
    }

    public boolean doesColumnExist(String tableName, String columnName) {
        boolean bl;
        block8: {
            LOG.finest("Checking if column {" + columnName + "} in table {" + tableName + "} exists.");
            ResultSet resultSet = this.getConnection().getMetaData().getColumns(null, null, tableName, columnName);
            try {
                bl = resultSet.next();
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to check for the existence of column " + tableName + "." + columnName + ".", (Throwable)e);
                }
            }
            resultSet.close();
        }
        return bl;
    }

    public boolean doesTableExist(String tableName) {
        boolean bl;
        block8: {
            LOG.finest("Checking if table {" + tableName + "} exists.");
            ResultSet resultSet = this.getConnection().getMetaData().getTables(null, null, tableName, new String[]{"TABLE"});
            try {
                bl = resultSet.next();
                if (resultSet == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OsmosisRuntimeException("Unable to check for the existence of table " + tableName + ".", (Throwable)e);
                }
            }
            resultSet.close();
        }
        return bl;
    }

    public void setAutoCommit(boolean autoCommit) {
        if (this.connection != null) {
            try {
                LOG.finest("Setting auto commit to " + autoCommit + ".");
                this.connection.setAutoCommit(autoCommit);
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to commit changes.", (Throwable)e);
            }
        }
        this.autoCommit = autoCommit;
    }

    public void commit() {
        if (this.connection != null) {
            try {
                LOG.finest("Committing changes.");
                this.connection.commit();
            }
            catch (SQLException e) {
                throw new OsmosisRuntimeException("Unable to commit changes.", (Throwable)e);
            }
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            try {
                LOG.finest("Closing the database connection.");
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.log(Level.WARNING, "Unable to close result set.", e);
            }
            this.connection = null;
        }
    }

    static {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new OsmosisRuntimeException("Unable to find database driver.", (Throwable)e);
        }
    }
}

