/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.v0_6.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ChangeReader;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityContainerReader;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityDataRowMapper;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistory;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistoryComparator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistoryReader;
import org.openstreetmap.osmosis.apidb.v0_6.impl.EntityHistoryRowMapper;
import org.openstreetmap.osmosis.apidb.v0_6.impl.FeatureHistoryPopulator;
import org.openstreetmap.osmosis.apidb.v0_6.impl.ReplicationQueryPredicates;
import org.openstreetmap.osmosis.apidb.v0_6.impl.TagRowMapper;
import org.openstreetmap.osmosis.core.container.v0_6.ChangeContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainer;
import org.openstreetmap.osmosis.core.container.v0_6.EntityContainerFactory;
import org.openstreetmap.osmosis.core.database.DbFeature;
import org.openstreetmap.osmosis.core.database.DbFeatureHistory;
import org.openstreetmap.osmosis.core.database.DbFeatureHistoryComparator;
import org.openstreetmap.osmosis.core.database.DbFeatureHistoryRowMapper;
import org.openstreetmap.osmosis.core.database.DbFeatureRowMapper;
import org.openstreetmap.osmosis.core.database.RowMapperListener;
import org.openstreetmap.osmosis.core.database.SortingStoreRowMapperListener;
import org.openstreetmap.osmosis.core.domain.v0_6.CommonEntityData;
import org.openstreetmap.osmosis.core.domain.v0_6.Entity;
import org.openstreetmap.osmosis.core.domain.v0_6.Tag;
import org.openstreetmap.osmosis.core.lifecycle.Closeable;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableContainer;
import org.openstreetmap.osmosis.core.lifecycle.ReleasableIterator;
import org.openstreetmap.osmosis.core.sort.common.FileBasedSort;
import org.openstreetmap.osmosis.core.store.ObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.SingleClassObjectSerializationFactory;
import org.openstreetmap.osmosis.core.store.StoreReleasingIterator;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public abstract class EntityDao<T extends Entity> {
    private static final Logger LOG = Logger.getLogger(EntityDao.class.getName());
    private JdbcTemplate jdbcTemplate;
    private NamedParameterJdbcTemplate namedParamJdbcTemplate;
    private String entityName;

    protected EntityDao(JdbcTemplate jdbcTemplate, String entityName) {
        this.jdbcTemplate = jdbcTemplate;
        this.namedParamJdbcTemplate = new NamedParameterJdbcTemplate((JdbcOperations)jdbcTemplate);
        this.entityName = entityName;
    }

    protected NamedParameterJdbcTemplate getNamedParamJdbcTemplate() {
        return this.namedParamJdbcTemplate;
    }

    protected abstract String[] getTypeSpecificFieldNames();

    protected abstract RowMapperListener<CommonEntityData> getEntityRowMapper(RowMapperListener<T> var1);

    protected abstract EntityContainerFactory<T> getContainerFactory();

    protected abstract List<FeatureHistoryPopulator<T, ?, ?>> getFeatureHistoryPopulators(String var1, MapSqlParameterSource var2);

    private String buildFeaturelessEntityHistoryQuery(String selectedEntityStatement) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT e.");
        sql.append(this.entityName);
        sql.append("_id AS id, e.version, e.timestamp, e.visible, u.data_public,");
        sql.append(" u.id AS user_id, u.display_name, e.changeset_id");
        for (String fieldName : this.getTypeSpecificFieldNames()) {
            sql.append(", e.");
            sql.append(fieldName);
        }
        sql.append(" FROM ");
        sql.append(this.entityName);
        sql.append("s e");
        sql.append(" INNER JOIN ");
        sql.append(selectedEntityStatement);
        sql.append(" t ON e.");
        sql.append(this.entityName);
        sql.append("_id = t.");
        sql.append(this.entityName);
        sql.append("_id AND e.version = t.version");
        sql.append(" INNER JOIN changesets c ON e.changeset_id = c.id INNER JOIN users u ON c.user_id = u.id");
        LOG.log(Level.FINER, "Entity history query: " + sql);
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<EntityHistory<T>> getFeaturelessEntityHistory(String selectedEntityStatement, MapSqlParameterSource parameterSource) {
        try (FileBasedSort sortingStore = new FileBasedSort((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(EntityHistory.class), new EntityHistoryComparator(), true);){
            String sql = this.buildFeaturelessEntityHistoryQuery(selectedEntityStatement);
            SortingStoreRowMapperListener storeListener = new SortingStoreRowMapperListener(sortingStore);
            EntityHistoryRowMapper entityHistoryRowMapper = new EntityHistoryRowMapper(storeListener);
            RowMapperListener<CommonEntityData> entityRowMapper = this.getEntityRowMapper(entityHistoryRowMapper);
            EntityDataRowMapper entityDataRowMapper = new EntityDataRowMapper(entityRowMapper, false);
            this.namedParamJdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowCallbackHandler)entityDataRowMapper);
            StoreReleasingIterator resultIterator = new StoreReleasingIterator(sortingStore.iterate(), (Closeable)sortingStore);
            sortingStore = null;
            StoreReleasingIterator storeReleasingIterator = resultIterator;
            return storeReleasingIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<DbFeatureHistory<DbFeature<Tag>>> getTagHistory(String selectedEntityStatement, MapSqlParameterSource parameterSource) {
        try (FileBasedSort sortingStore = new FileBasedSort((ObjectSerializationFactory)new SingleClassObjectSerializationFactory(DbFeatureHistory.class), (Comparator)new DbFeatureHistoryComparator(), true);){
            String sql = "SELECT et." + this.entityName + "_id AS id, et.k, et.v, et.version FROM " + this.entityName + "_tags et INNER JOIN " + selectedEntityStatement + " t ON et." + this.entityName + "_id = t." + this.entityName + "_id AND et.version = t.version";
            LOG.log(Level.FINER, "Tag history query: " + sql);
            SortingStoreRowMapperListener storeListener = new SortingStoreRowMapperListener(sortingStore);
            DbFeatureHistoryRowMapper dbFeatureHistoryRowMapper = new DbFeatureHistoryRowMapper((RowMapperListener)storeListener);
            DbFeatureRowMapper dbFeatureRowMapper = new DbFeatureRowMapper((RowMapperListener)dbFeatureHistoryRowMapper);
            TagRowMapper tagRowMapper = new TagRowMapper((RowMapperListener<Tag>)dbFeatureRowMapper);
            this.namedParamJdbcTemplate.query(sql, (SqlParameterSource)parameterSource, (RowCallbackHandler)tagRowMapper);
            StoreReleasingIterator resultIterator = new StoreReleasingIterator(sortingStore.iterate(), (Closeable)sortingStore);
            sortingStore = null;
            StoreReleasingIterator storeReleasingIterator = resultIterator;
            return storeReleasingIterator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReleasableIterator<EntityHistory<T>> getEntityHistory(String selectedEntityStatement, MapSqlParameterSource parameterSource) {
        try (ReleasableContainer releasableContainer = new ReleasableContainer();){
            ReleasableIterator entityIterator = (ReleasableIterator)releasableContainer.add(this.getFeaturelessEntityHistory(selectedEntityStatement, parameterSource));
            ReleasableIterator tagIterator = (ReleasableIterator)releasableContainer.add(this.getTagHistory(selectedEntityStatement, parameterSource));
            List<FeatureHistoryPopulator<T, ?, ?>> featurePopulators = this.getFeatureHistoryPopulators(selectedEntityStatement, parameterSource);
            for (FeatureHistoryPopulator<T, ?, ?> featurePopulator : featurePopulators) {
                releasableContainer.add(featurePopulator);
            }
            EntityHistoryReader<T> entityHistoryReader = new EntityHistoryReader<T>(entityIterator, (ReleasableIterator<DbFeatureHistory<DbFeature<Tag>>>)tagIterator, featurePopulators);
            releasableContainer.clear();
            EntityHistoryReader<T> entityHistoryReader2 = entityHistoryReader;
            return entityHistoryReader2;
        }
    }

    private ReleasableIterator<ChangeContainer> getChangeHistory(String selectedEntityStatement, MapSqlParameterSource parameterSource) {
        return new ChangeReader<T>(this.getEntityHistory(selectedEntityStatement, parameterSource), this.getContainerFactory());
    }

    private List<Integer> buildTransactionRanges(long bottomTransactionId, long topTransactionId) {
        ArrayList<Integer> rangeValues = new ArrayList<Integer>();
        if (bottomTransactionId == topTransactionId) {
            return rangeValues;
        }
        int currentXid = (int)bottomTransactionId;
        rangeValues.add(currentXid);
        int finishXid = (int)topTransactionId - 1;
        do {
            if (currentXid <= 2 && finishXid >= 0) {
                rangeValues.add(-1);
                rangeValues.add(3);
                currentXid = 3;
                continue;
            }
            if (finishXid < currentXid) {
                rangeValues.add(Integer.MAX_VALUE);
                rangeValues.add(Integer.MIN_VALUE);
                currentXid = Integer.MIN_VALUE;
                continue;
            }
            rangeValues.add(finishXid);
            currentXid = finishXid;
        } while (currentXid != finishXid);
        return rangeValues;
    }

    private void buildTransactionRangeWhereClause(StringBuilder sql, MapSqlParameterSource parameters, long bottomTransactionId, long topTransactionId) {
        List<Integer> rangeValues = this.buildTransactionRanges(bottomTransactionId, topTransactionId);
        for (int i = 0; i < rangeValues.size(); i += 2) {
            if (i > 0) {
                sql.append(" OR ");
            }
            sql.append("(");
            sql.append("xid_to_int4(xmin) >= :rangeValue").append(i);
            sql.append(" AND ");
            sql.append("xid_to_int4(xmin) <= :rangeValue").append(i + 1);
            sql.append(")");
            parameters.addValue("rangeValue" + i, (Object)rangeValues.get(i), 4);
            parameters.addValue("rangeValue" + (i + 1), (Object)rangeValues.get(i + 1), 4);
        }
    }

    private void buildTransactionIdListWhereClause(StringBuilder sql, List<Long> transactionIdList) {
        for (int i = 0; i < transactionIdList.size(); ++i) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append((int)transactionIdList.get(i).longValue());
        }
    }

    public ReleasableIterator<ChangeContainer> getHistory(ReplicationQueryPredicates predicates) {
        this.jdbcTemplate.execute("set local enable_seqscan = false;set local enable_mergejoin = false;set local enable_hashjoin = false");
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        String selectedEntityTableName = "tmp_" + this.entityName + "s";
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TEMPORARY TABLE ");
        sql.append(selectedEntityTableName);
        sql.append(" ON COMMIT DROP");
        sql.append(" AS SELECT ");
        sql.append(this.entityName);
        sql.append("_id, version FROM ");
        sql.append(this.entityName);
        sql.append("s WHERE ((");
        this.buildTransactionRangeWhereClause(sql, parameterSource, predicates.getBottomTransactionId(), predicates.getTopTransactionId());
        sql.append(")");
        if (predicates.getReadyList().size() > 0) {
            sql.append(" OR xid_to_int4(xmin) IN (");
            this.buildTransactionIdListWhereClause(sql, predicates.getReadyList());
            sql.append(")");
        }
        sql.append(")");
        if (predicates.getActiveList().size() > 0) {
            sql.append(" AND xid_to_int4(xmin) NOT IN (");
            this.buildTransactionIdListWhereClause(sql, predicates.getActiveList());
            sql.append(")");
        }
        sql.append(" AND redaction_id IS NULL");
        LOG.log(Level.FINER, "Entity identification query: " + sql);
        this.namedParamJdbcTemplate.update(sql.toString(), (SqlParameterSource)parameterSource);
        this.jdbcTemplate.update("ALTER TABLE ONLY " + selectedEntityTableName + " ADD CONSTRAINT pk_" + selectedEntityTableName + " PRIMARY KEY (" + this.entityName + "_id, version)");
        this.jdbcTemplate.update("ANALYZE " + selectedEntityTableName);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, this.jdbcTemplate.queryForObject("SELECT Count(" + this.entityName + "_id) FROM " + selectedEntityTableName, Integer.class) + " " + this.entityName + " records located.");
        }
        ReleasableIterator<ChangeContainer> historyIterator = this.getChangeHistory(selectedEntityTableName, new MapSqlParameterSource());
        this.jdbcTemplate.execute("DROP TABLE " + selectedEntityTableName);
        return historyIterator;
    }

    public ReleasableIterator<ChangeContainer> getHistory(Date intervalBegin, Date intervalEnd) {
        this.jdbcTemplate.execute("set local enable_seqscan = false;set local enable_mergejoin = false;set local enable_hashjoin = false");
        String selectedEntityTableName = "tmp_" + this.entityName + "s";
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TEMPORARY TABLE ");
        sql.append(selectedEntityTableName);
        sql.append(" ON COMMIT DROP");
        sql.append(" AS SELECT ");
        sql.append(this.entityName);
        sql.append("_id, version FROM ");
        sql.append(this.entityName);
        sql.append("s WHERE timestamp > :intervalBegin AND timestamp <= :intervalEnd");
        LOG.log(Level.FINER, "Entity identification query: " + sql);
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("intervalBegin", (Object)intervalBegin, 93);
        parameterSource.addValue("intervalEnd", (Object)intervalEnd, 93);
        this.namedParamJdbcTemplate.update(sql.toString(), (SqlParameterSource)parameterSource);
        this.jdbcTemplate.update("ANALYZE " + selectedEntityTableName);
        ReleasableIterator<ChangeContainer> historyIterator = this.getChangeHistory(selectedEntityTableName, new MapSqlParameterSource());
        this.jdbcTemplate.execute("DROP TABLE " + selectedEntityTableName);
        return historyIterator;
    }

    public ReleasableIterator<ChangeContainer> getHistory() {
        return this.getChangeHistory(this.entityName + "s", new MapSqlParameterSource());
    }

    public ReleasableIterator<EntityContainer> getCurrent() {
        return new EntityContainerReader<T>(this.getEntityHistory("(SELECT id AS " + this.entityName + "_id, version FROM current_" + this.entityName + "s WHERE visible = TRUE)", new MapSqlParameterSource()), this.getContainerFactory());
    }
}

