/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.osmosis.apidb.common;

import java.util.Objects;
import org.openstreetmap.osmosis.apidb.common.DatabaseContext2;
import org.openstreetmap.osmosis.apidb.common.IdentityValueLoader;

public class PostgresqlIdentityValueLoader2
implements IdentityValueLoader {
    private static final String SQL_SELECT_LAST_INSERT_ID = "SELECT lastval() AS lastInsertId";
    private static final String SQL_SELECT_LAST_SEQUENCE_ID = "SELECT currval(?) AS lastSequenceId";
    private DatabaseContext2 dbCtx;

    public PostgresqlIdentityValueLoader2(DatabaseContext2 dbCtx) {
        this.dbCtx = dbCtx;
    }

    @Override
    public long getLastInsertId() {
        return Objects.requireNonNull((Long)this.dbCtx.getJdbcTemplate().queryForObject(SQL_SELECT_LAST_INSERT_ID, Long.class), "Last insert ID was not found");
    }

    @Override
    public long getLastSequenceId(String sequenceName) {
        return (Long)this.dbCtx.getJdbcTemplate().queryForObject(SQL_SELECT_LAST_SEQUENCE_ID, Long.class, new Object[]{sequenceName});
    }

    public void close() {
    }
}

