/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.device;

import com.android.bundle.Commands;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.device.DeviceSpecUtils;
import com.android.tools.build.bundletool.model.ConfigurationSizes;
import com.android.tools.build.bundletool.model.GetSizeRequest;
import com.android.tools.build.bundletool.model.SizeConfiguration;
import com.android.tools.build.bundletool.model.utils.TextureCompressionUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractSizeAggregator {
    private static final Joiner COMMA_JOINER = Joiner.on(',');
    protected final ImmutableMap<String, Long> sizeByApkPaths;
    protected final GetSizeRequest getSizeRequest;

    protected AbstractSizeAggregator(ImmutableMap<String, Long> sizeByApkPaths, GetSizeRequest getSizeRequest) {
        this.sizeByApkPaths = sizeByApkPaths;
        this.getSizeRequest = getSizeRequest;
    }

    public abstract ConfigurationSizes getSize();

    protected abstract ImmutableList<ApkMatcher.GeneratedApk> getMatchingApks(Targeting.SdkVersionTargeting var1, Targeting.AbiTargeting var2, Targeting.ScreenDensityTargeting var3, Targeting.LanguageTargeting var4, Targeting.TextureCompressionFormatTargeting var5, Targeting.DeviceGroupTargeting var6, Targeting.DeviceTierTargeting var7, Targeting.CountrySetTargeting var8, Targeting.SdkRuntimeTargeting var9);

    protected ImmutableSet<Targeting.SdkVersionTargeting> getAllSdkVersionTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isSdkVersionMissing, Targeting.ApkTargeting::hasSdkVersionTargeting, Targeting.ApkTargeting::getSdkVersionTargeting, Targeting.SdkVersionTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.AbiTargeting> getAllAbiTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isAbiMissing, Targeting.ApkTargeting::hasAbiTargeting, Targeting.ApkTargeting::getAbiTargeting, Targeting.AbiTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.ScreenDensityTargeting> getAllScreenDensityTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isScreenDensityMissing, Targeting.ApkTargeting::hasScreenDensityTargeting, Targeting.ApkTargeting::getScreenDensityTargeting, Targeting.ScreenDensityTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.LanguageTargeting> getAllLanguageTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isLocalesMissing, Targeting.ApkTargeting::hasLanguageTargeting, Targeting.ApkTargeting::getLanguageTargeting, Targeting.LanguageTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.TextureCompressionFormatTargeting> getAllTextureCompressionFormatTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isTextureCompressionFormatMissing, Targeting.ApkTargeting::hasTextureCompressionFormatTargeting, Targeting.ApkTargeting::getTextureCompressionFormatTargeting, Targeting.TextureCompressionFormatTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.DeviceTierTargeting> getAllDeviceTierTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isDeviceTierMissing, Targeting.ApkTargeting::hasDeviceTierTargeting, Targeting.ApkTargeting::getDeviceTierTargeting, Targeting.DeviceTierTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.DeviceGroupTargeting> getAllDeviceGroupTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isDeviceGroupsMissing, Targeting.ApkTargeting::hasDeviceGroupTargeting, Targeting.ApkTargeting::getDeviceGroupTargeting, Targeting.DeviceGroupTargeting.getDefaultInstance());
    }

    protected ImmutableSet<Targeting.CountrySetTargeting> getAllCountrySetTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions) {
        return this.getAllTargetings(apkDescriptions, DeviceSpecUtils::isCountrySetMissing, Targeting.ApkTargeting::hasCountrySetTargeting, Targeting.ApkTargeting::getCountrySetTargeting, Targeting.CountrySetTargeting.getDefaultInstance());
    }

    protected <T extends Message> ImmutableSet<T> getAllTargetings(ImmutableList<Commands.ApkDescription> apkDescriptions, Predicate<Devices.DeviceSpec> isDimensionMissingFromDevice, Predicate<Targeting.ApkTargeting> hasTargeting, Function<Targeting.ApkTargeting, T> getTargeting, T defaultInstance) {
        ImmutableSet targetingOptions = isDimensionMissingFromDevice.test(this.getSizeRequest.getDeviceSpec()) ? apkDescriptions.stream().map(Commands.ApkDescription::getTargeting).filter(hasTargeting).map(getTargeting).collect(ImmutableSet.toImmutableSet()) : ImmutableSet.of();
        return targetingOptions.isEmpty() ? ImmutableSet.of(defaultInstance) : targetingOptions;
    }

    protected ConfigurationSizes getSizesPerConfiguration(ImmutableSet<Targeting.SdkVersionTargeting> sdkTargetingOptions, ImmutableSet<Targeting.AbiTargeting> abiTargetingOptions, ImmutableSet<Targeting.LanguageTargeting> languageTargetingOptions, ImmutableSet<Targeting.ScreenDensityTargeting> screenDensityTargetingOptions, ImmutableSet<Targeting.TextureCompressionFormatTargeting> textureCompressionFormatTargetingOptions, ImmutableSet<Targeting.DeviceGroupTargeting> deviceGroupTargetingOptions, ImmutableSet<Targeting.DeviceTierTargeting> deviceTierTargetingOptions, ImmutableSet<Targeting.CountrySetTargeting> countrySetTargetingOptions, Targeting.SdkRuntimeTargeting sdkRuntimeTargeting) {
        HashMap<SizeConfiguration, Long> minSizeByConfiguration = new HashMap<SizeConfiguration, Long>();
        HashMap<SizeConfiguration, Long> maxSizeByConfiguration = new HashMap<SizeConfiguration, Long>();
        for (Targeting.SdkVersionTargeting sdkVersionTargeting : sdkTargetingOptions) {
            for (Targeting.AbiTargeting abiTargeting : abiTargetingOptions) {
                for (Targeting.ScreenDensityTargeting screenDensityTargeting : screenDensityTargetingOptions) {
                    for (Targeting.LanguageTargeting languageTargeting : languageTargetingOptions) {
                        for (Targeting.TextureCompressionFormatTargeting textureCompressionFormatTargeting : textureCompressionFormatTargetingOptions) {
                            for (Targeting.DeviceGroupTargeting deviceGroupTargeting : deviceGroupTargetingOptions) {
                                for (Targeting.DeviceTierTargeting deviceTierTargeting : deviceTierTargetingOptions) {
                                    for (Targeting.CountrySetTargeting countrySetTargeting : countrySetTargetingOptions) {
                                        SizeConfiguration configuration = this.mergeWithDeviceSpec(this.getSizeConfiguration(sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting, textureCompressionFormatTargeting, deviceGroupTargeting, deviceTierTargeting, countrySetTargeting, sdkRuntimeTargeting), this.getSizeRequest.getDeviceSpec());
                                        long compressedSize = this.getCompressedSize(this.getMatchingApks(sdkVersionTargeting, abiTargeting, screenDensityTargeting, languageTargeting, textureCompressionFormatTargeting, deviceGroupTargeting, deviceTierTargeting, countrySetTargeting, sdkRuntimeTargeting));
                                        minSizeByConfiguration.merge(configuration, compressedSize, Math::min);
                                        maxSizeByConfiguration.merge(configuration, compressedSize, Math::max);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return ConfigurationSizes.create(ImmutableMap.copyOf(minSizeByConfiguration), ImmutableMap.copyOf(maxSizeByConfiguration));
    }

    protected SizeConfiguration getSizeConfiguration(Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting, Targeting.TextureCompressionFormatTargeting textureCompressionFormatTargeting, Targeting.DeviceGroupTargeting deviceGroupTargeting, Targeting.DeviceTierTargeting deviceTierTargeting, Targeting.CountrySetTargeting countrySetTargeting, Targeting.SdkRuntimeTargeting sdkRuntimeTargeting) {
        ImmutableSet<GetSizeRequest.Dimension> dimensions = this.getSizeRequest.getDimensions();
        SizeConfiguration.Builder sizeConfiguration = SizeConfiguration.builder();
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SDK)) {
            SizeConfiguration.getSdkName(sdkVersionTargeting).ifPresent(sizeConfiguration::setSdkVersion);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.ABI)) {
            SizeConfiguration.getAbiName(abiTargeting).ifPresent(sizeConfiguration::setAbi);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SCREEN_DENSITY)) {
            SizeConfiguration.getScreenDensityName(screenDensityTargeting).ifPresent(sizeConfiguration::setScreenDensity);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.LANGUAGE)) {
            SizeConfiguration.getLocaleName(languageTargeting).ifPresent(sizeConfiguration::setLocale);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.TEXTURE_COMPRESSION_FORMAT)) {
            SizeConfiguration.getTextureCompressionFormatName(textureCompressionFormatTargeting).ifPresent(sizeConfiguration::setTextureCompressionFormat);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.DEVICE_TIER)) {
            SizeConfiguration.getDeviceTierLevel(deviceTierTargeting).ifPresent(sizeConfiguration::setDeviceTier);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.DEVICE_GROUP)) {
            SizeConfiguration.getDeviceGroupName(deviceGroupTargeting).ifPresent(sizeConfiguration::setDeviceGroup);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.COUNTRY_SET)) {
            SizeConfiguration.getCountrySetName(countrySetTargeting).ifPresent(sizeConfiguration::setCountrySet);
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SDK_RUNTIME)) {
            sizeConfiguration.setSdkRuntime(SizeConfiguration.getSdkRuntimeRequired(sdkRuntimeTargeting));
        }
        return sizeConfiguration.build();
    }

    protected Devices.DeviceSpec getDeviceSpec(Devices.DeviceSpec deviceSpec, Targeting.SdkVersionTargeting sdkVersionTargeting, Targeting.AbiTargeting abiTargeting, Targeting.ScreenDensityTargeting screenDensityTargeting, Targeting.LanguageTargeting languageTargeting, Targeting.TextureCompressionFormatTargeting textureTargeting, Targeting.DeviceGroupTargeting deviceGroupTargeting, Targeting.DeviceTierTargeting deviceTierTargeting, Targeting.CountrySetTargeting countrySetTargeting, Targeting.SdkRuntimeTargeting sdkRuntimeTargeting) {
        return new DeviceSpecUtils.DeviceSpecFromTargetingBuilder(deviceSpec).setSdkVersion(sdkVersionTargeting).setSupportedAbis(abiTargeting).setScreenDensity(screenDensityTargeting).setSupportedLocales(languageTargeting).setSupportedTextureCompressionFormats(textureTargeting).setDeviceGroup(deviceGroupTargeting).setDeviceTier(deviceTierTargeting).setCountrySet(countrySetTargeting).setSdkRuntime(sdkRuntimeTargeting).build();
    }

    protected SizeConfiguration mergeWithDeviceSpec(SizeConfiguration getSizeConfiguration, Devices.DeviceSpec deviceSpec) {
        ImmutableSet<GetSizeRequest.Dimension> dimensions = this.getSizeRequest.getDimensions();
        SizeConfiguration.Builder mergedSizeConfiguration = getSizeConfiguration.toBuilder();
        if (dimensions.contains((Object)GetSizeRequest.Dimension.ABI) && !DeviceSpecUtils.isAbiMissing(deviceSpec)) {
            mergedSizeConfiguration.setAbi(COMMA_JOINER.join(deviceSpec.getSupportedAbisList()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SCREEN_DENSITY) && !DeviceSpecUtils.isScreenDensityMissing(deviceSpec)) {
            mergedSizeConfiguration.setScreenDensity(Integer.toString(deviceSpec.getScreenDensity()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.LANGUAGE) && !DeviceSpecUtils.isLocalesMissing(deviceSpec)) {
            mergedSizeConfiguration.setLocale(COMMA_JOINER.join(deviceSpec.getSupportedLocalesList()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SDK) && !DeviceSpecUtils.isSdkVersionMissing(deviceSpec)) {
            mergedSizeConfiguration.setSdkVersion(String.format("%d", deviceSpec.getSdkVersion()));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.TEXTURE_COMPRESSION_FORMAT) && !DeviceSpecUtils.isTextureCompressionFormatMissing(deviceSpec)) {
            mergedSizeConfiguration.setTextureCompressionFormat(COMMA_JOINER.join(DeviceSpecUtils.getDeviceSupportedTextureCompressionFormats(deviceSpec).stream().map(TextureCompressionUtils.TARGETING_TO_TEXTURE::get).collect(ImmutableList.toImmutableList())));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.DEVICE_TIER) && !DeviceSpecUtils.isDeviceTierMissing(deviceSpec)) {
            mergedSizeConfiguration.setDeviceTier(deviceSpec.getDeviceTier().getValue());
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.DEVICE_GROUP) && !DeviceSpecUtils.isDeviceGroupsMissing(deviceSpec)) {
            mergedSizeConfiguration.setDeviceGroup(deviceSpec.getDeviceGroups(0));
        }
        if (dimensions.contains((Object)GetSizeRequest.Dimension.SDK_RUNTIME) && !DeviceSpecUtils.isSdkRuntimeUnspecified(deviceSpec)) {
            mergedSizeConfiguration.setSdkRuntime(deviceSpec.getSdkRuntime().getSupported() ? "Required" : "Not Required");
        }
        return mergedSizeConfiguration.build();
    }

    private long getCompressedSize(ImmutableList<ApkMatcher.GeneratedApk> apks) {
        return apks.stream().mapToLong(apk -> this.sizeByApkPaths.get(apk.getPath().toString())).sum();
    }
}

