# Extraction of CMake signatures

The signatures are obtained from CMake html docs generated by CLion. The docs are already preprocessed by CLion which is necessary for
replacing some sections by predefined blocks.The docs parsing has two steps.

The first step concerns identifying code blocks containing a CMake command signature. This step is done by the `extract_commands.py` script
which finds all sections in the `<pre>` tags. Then the section is divided into methods calls and irrelevant ones are filtered out. The
results are saved into the JSON file placed in the `cmaka-psi/resources/commandSignatures` folder.

The JSON can be manually adjusted to fix inconsistent formatting. This manual adjustment helps parser to properly identify the command
signatures.

In the end, the resource is loaded during the runtime where the parser extracts information about signatures from the selected code in the
JSON.

## Using extract_commands.py

There is the run configuration `extract_commands` which has already predefined arguments for the script. The configuration uses CMake html
command docs generated by CLion (see folder `clion/bin/cmkae/quickdoc/command` and `clion/bin/cmkae/quickdoc/module`) as the input. You can
change it by adjusting the script argument. The configuration uses `cmake-psi/resources/commandSignatures/output_code_blocks_manual.json` as
the output. You should always use this filename in order to CLion finds the resource.

## Manual adjustment of JSON

Currently, the parser just finds patterns which are common for keywords. But it is useful to keep the following formatting consistent for
future better identification of whole signatures.

| Argument type | Format                                      | Example                                            | 
|---------------|---------------------------------------------|----------------------------------------------------|
| keyword       | `[A-Z_]+`                                   | `VERSION`, `(backtick)NONStanardKeyworD(backtick)` |
| variable      | `<[a-z_-]+>`                                | `<myvar>`                                          |
| optional      | `[ (argument_type) ]`                       | `[ VERSION ]`                                      |
| option        | `-[A-Za-z_-]+`                              | `-jar`                                             |
| choice        | `{ (argument_type&#124;)+(argument_type) }` | `{ VERSION 3.14 &#124; VERSION 2.12 }`             |
| list          | `argument_type ...`                         | `arg ...`, `{ ARG arg } ...`                       |

## Merging a new version of CMake docs

There can be a new version of CMake docs while there is already manually adjusted the JSON generated from the previous version. It is useful
to use a diff tool in this situation. Generate a new version of the JSON and then compare the current and previous version. There shouldn't
be a lot of changes in the signatures. So, make a fix of differences and replace the previous JSON by the current one.

