/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AnnotationExprent;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TargetInfo;
import org.jetbrains.java.decompiler.modules.decompiler.typeann.TypeAnnotation;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructTypeAnnotationAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.struct.gen.Type;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public abstract class StructMember {
    private final int accessFlags;
    private final Map<String, StructGeneralAttribute> attributes;

    protected StructMember(int accessFlags, Map<String, StructGeneralAttribute> attributes) {
        this.accessFlags = accessFlags;
        this.attributes = attributes;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public <T extends StructGeneralAttribute> T getAttribute(StructGeneralAttribute.Key<T> attribute) {
        StructGeneralAttribute t = this.attributes.get(attribute.name);
        return (T)t;
    }

    public boolean hasAttribute(StructGeneralAttribute.Key<?> attribute) {
        return this.attributes.containsKey(attribute.name);
    }

    public boolean hasModifier(int modifier) {
        return (this.accessFlags & modifier) == modifier;
    }

    public boolean isSynthetic() {
        return this.hasModifier(4096) || this.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
    }

    protected abstract Type getType();

    public boolean memberAnnCollidesWithTypeAnnotation(AnnotationExprent typeAnnotationExpr) {
        Set typeAnnotations = TargetInfo.EmptyTarget.extract(this.getPossibleTypeAnnotationCollisions(this.getType())).stream().map(typeAnnotation -> typeAnnotation.getAnnotationExpr()).collect(Collectors.toUnmodifiableSet());
        return typeAnnotations.contains(typeAnnotationExpr);
    }

    public boolean paramAnnCollidesWithTypeAnnotation(AnnotationExprent typeAnnotationExpr, Type type, int param) {
        Set typeAnnotations = TargetInfo.FormalParameterTarget.extract(this.getPossibleTypeAnnotationCollisions(type), param).stream().map(typeAnnotation -> typeAnnotation.getAnnotationExpr()).collect(Collectors.toUnmodifiableSet());
        return typeAnnotations.contains(typeAnnotationExpr);
    }

    private List<TypeAnnotation> getPossibleTypeAnnotationCollisions(Type type) {
        return Arrays.stream(StructGeneralAttribute.TYPE_ANNOTATION_ATTRIBUTES).flatMap(attrKey -> {
            StructTypeAnnotationAttribute attribute = (StructTypeAnnotationAttribute)this.getAttribute((StructGeneralAttribute.Key)attrKey);
            if (attribute == null) {
                return Stream.empty();
            }
            return attribute.getAnnotations().stream();
        }).filter(ta -> ta.isWrittenBeforeType(type)).collect(Collectors.toList());
    }

    public static Map<String, StructGeneralAttribute> readAttributes(DataInputFullStream in, ConstantPool pool) throws IOException {
        int length = in.readUnsignedShort();
        HashMap<String, StructGeneralAttribute> attributes = new HashMap<String, StructGeneralAttribute>(length);
        for (int i = 0; i < length; ++i) {
            StructGeneralAttribute table;
            int nameIndex = in.readUnsignedShort();
            String name = pool.getPrimitiveConstant(nameIndex).getString();
            StructGeneralAttribute attribute = StructGeneralAttribute.createAttribute(name);
            int attLength = in.readInt();
            if (attribute == null) {
                in.discard(attLength);
                continue;
            }
            attribute.initContent(in, pool);
            if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE.name.equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTableAttribute)attributes.get(name);
                ((StructLocalVariableTableAttribute)table).add((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE.name.equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTypeTableAttribute)attributes.get(name);
                ((StructLocalVariableTypeTableAttribute)table).add((StructLocalVariableTypeTableAttribute)attribute);
                continue;
            }
            attributes.put(name, attribute);
        }
        return attributes;
    }
}

