/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.vars;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.ConstExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class VarTypeProcessor {
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private final Map<VarVersionPair, VarType> minExprentTypes = new HashMap<VarVersionPair, VarType>();
    private final Map<VarVersionPair, VarType> maxExprentTypes = new HashMap<VarVersionPair, VarType>();
    private final Map<VarVersionPair, Integer> finalVariables = new HashMap<VarVersionPair, Integer>();

    public VarTypeProcessor(@NotNull StructMethod method, @NotNull MethodDescriptor methodDescriptor) {
        this.method = method;
        this.methodDescriptor = methodDescriptor;
    }

    public void calculateVarTypes(@NotNull RootStatement root, @NotNull DirectGraph graph) {
        this.setInitVariables();
        this.setCatchBlockVariables(root);
        VarTypeProcessor.resetExprentTypes(graph);
        while (!this.processVarTypes(graph)) {
        }
    }

    private void setInitVariables() {
        VarType[] methodParameters;
        boolean thisVar;
        boolean bl = thisVar = !this.method.hasModifier(8);
        if (thisVar) {
            StructClass currentClass = (StructClass)DecompilerContext.getProperty("CURRENT_CLASS");
            VarType classType = new VarType(8, 0, currentClass.qualifiedName);
            this.minExprentTypes.put(new VarVersionPair(0, 1), classType);
            this.maxExprentTypes.put(new VarVersionPair(0, 1), classType);
        }
        int varIndex = 0;
        for (VarType parameter : methodParameters = this.methodDescriptor.params) {
            this.minExprentTypes.put(new VarVersionPair(varIndex + (thisVar ? 1 : 0), 1), parameter);
            this.maxExprentTypes.put(new VarVersionPair(varIndex + (thisVar ? 1 : 0), 1), parameter);
            varIndex += parameter.getStackSize();
        }
    }

    private void setCatchBlockVariables(@NotNull RootStatement root) {
        LinkedList<RootStatement> statements = new LinkedList<RootStatement>();
        statements.add(root);
        while (!statements.isEmpty()) {
            Statement statement = (Statement)statements.removeFirst();
            List<VarExprent> catchVariables = null;
            if (statement.type == Statement.StatementType.CATCH_ALL) {
                catchVariables = ((CatchAllStatement)statement).getVars();
            } else if (statement.type == Statement.StatementType.TRY_CATCH) {
                catchVariables = ((CatchStatement)statement).getVars();
            }
            if (catchVariables != null) {
                for (VarExprent catchVariable : catchVariables) {
                    this.minExprentTypes.put(new VarVersionPair(catchVariable.getIndex(), 1), catchVariable.getVarType());
                    this.maxExprentTypes.put(new VarVersionPair(catchVariable.getIndex(), 1), catchVariable.getVarType());
                }
            }
            statements.addAll(statement.getStats());
        }
    }

    private boolean checkTypeExprent(@NotNull Exprent currentExprent) {
        CheckTypesResult exprentTypeBounds;
        Object varVersion;
        ConstExprent constExprent;
        for (Exprent exprent : currentExprent.getAllExprents()) {
            if (this.checkTypeExprent(exprent)) continue;
            return false;
        }
        if (currentExprent.type == 3 && (constExprent = (ConstExprent)currentExprent).getConstType().getTypeFamily() <= 2 && !this.minExprentTypes.containsKey(varVersion = new VarVersionPair(constExprent.id, -1))) {
            this.minExprentTypes.put((VarVersionPair)varVersion, constExprent.getConstType());
        }
        if ((exprentTypeBounds = currentExprent.checkExprTypeBounds()) == null) {
            return true;
        }
        for (CheckTypesResult.ExprentTypePair entry : exprentTypeBounds.getMaxTypeExprents()) {
            if (entry.type.getTypeFamily() == 6) continue;
            this.changeExprentType(entry.exprent, entry.type, false);
        }
        boolean result = true;
        for (CheckTypesResult.ExprentTypePair entry : exprentTypeBounds.getMinTypeExprents()) {
            result &= this.changeExprentType(entry.exprent, entry.type, true);
        }
        return result;
    }

    private boolean processVarTypes(@NotNull DirectGraph graph) {
        return graph.iterateExprents(exprent -> this.checkTypeExprent(exprent) ? 0 : 1);
    }

    private boolean changeExprentType(@NotNull Exprent exprent, @NotNull VarType newType, boolean checkMinExprentType) {
        if (exprent.type == 3) {
            VarType integerType;
            ConstExprent constExprent = (ConstExprent)exprent;
            VarType constType = constExprent.getConstType();
            if (newType.getTypeFamily() > 2 || constType.getTypeFamily() > 2) {
                return true;
            }
            if (newType.getTypeFamily() == 2 && (integerType = new ConstExprent((Integer)constExprent.getValue(), false, null).getConstType()).isStrictSuperset(newType)) {
                newType = integerType;
            }
            return this.changeConstExprentType(new VarVersionPair(exprent.id, -1), exprent, newType, checkMinExprentType);
        }
        if (exprent.type == 12) {
            return this.changeConstExprentType(new VarVersionPair((VarExprent)exprent), exprent, newType, checkMinExprentType);
        }
        if (exprent.type == 2) {
            return this.changeExprentType(((AssignmentExprent)exprent).getRight(), newType, checkMinExprentType);
        }
        if (exprent.type == 6) {
            FunctionExprent functionExprent = (FunctionExprent)exprent;
            switch (functionExprent.getFuncType()) {
                case 36: {
                    return this.changeExprentType(functionExprent.getLstOperands().get(1), newType, checkMinExprentType) & this.changeExprentType(functionExprent.getLstOperands().get(2), newType, checkMinExprentType);
                }
                case 4: 
                case 5: 
                case 6: {
                    return this.changeExprentType(functionExprent.getLstOperands().get(0), newType, checkMinExprentType) & this.changeExprentType(functionExprent.getLstOperands().get(1), newType, checkMinExprentType);
                }
            }
        }
        return true;
    }

    private boolean changeConstExprentType(@NotNull VarVersionPair varVersion, @NotNull Exprent exprent, @NotNull VarType newType, boolean checkMinExprentType) {
        VarType newMaxType;
        if (checkMinExprentType) {
            VarType newMinType;
            VarType currentMinType = this.minExprentTypes.get(varVersion);
            if (currentMinType == null || newType.getTypeFamily() > currentMinType.getTypeFamily()) {
                newMinType = newType;
            } else {
                if (newType.getTypeFamily() < currentMinType.getTypeFamily()) {
                    return true;
                }
                newMinType = VarType.getCommonSupertype(currentMinType, newType);
            }
            this.minExprentTypes.put(varVersion, newMinType);
            if (exprent.type == 3) {
                ((ConstExprent)exprent).setConstType(newMinType);
            }
            return currentMinType == null || newMinType.getTypeFamily() <= currentMinType.getTypeFamily() && !newMinType.isStrictSuperset(currentMinType);
        }
        VarType currentMaxType = this.maxExprentTypes.get(varVersion);
        if (currentMaxType == null || newType.getTypeFamily() < currentMaxType.getTypeFamily()) {
            newMaxType = newType;
        } else {
            if (newType.getTypeFamily() > currentMaxType.getTypeFamily()) {
                return true;
            }
            newMaxType = VarType.getCommonMinType(currentMaxType, newType);
        }
        this.maxExprentTypes.put(varVersion, newMaxType);
        return true;
    }

    private static void resetExprentTypes(@NotNull DirectGraph graph) {
        graph.iterateExprents(currExprent -> {
            List<Exprent> allExprents = currExprent.getAllExprents(true);
            allExprents.add(currExprent);
            for (Exprent exprent : allExprents) {
                ConstExprent constExprent;
                if (exprent.type == 12) {
                    ((VarExprent)exprent).setVarType(VarType.VARTYPE_UNKNOWN);
                    continue;
                }
                if (exprent.type != 3 || (constExprent = (ConstExprent)exprent).getConstType().getTypeFamily() != 2) continue;
                constExprent.setConstType(new ConstExprent(constExprent.getIntValue(), constExprent.isBoolPermitted(), null).getConstType());
            }
            return 0;
        });
    }

    public Map<VarVersionPair, VarType> getMaxExprentTypes() {
        return this.maxExprentTypes;
    }

    public Map<VarVersionPair, VarType> getMinExprentTypes() {
        return this.minExprentTypes;
    }

    public Map<VarVersionPair, Integer> getFinalVariables() {
        return this.finalVariables;
    }

    public VarType getVarType(VarVersionPair pair) {
        return this.minExprentTypes.get(pair);
    }

    public void setVarType(VarVersionPair pair, VarType type) {
        this.minExprentTypes.put(pair, type);
    }
}

