/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.java.decompiler.modules.decompiler.exps.AssignmentExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.FunctionExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.NewExprent;
import org.jetbrains.java.decompiler.modules.decompiler.exps.VarExprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.FlattenStatementsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionEdge;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionNode;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionPair;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarVersionsGraph;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.util.FastSparseSetFactory;
import org.jetbrains.java.decompiler.util.SFormsFastMapDirect;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public class SSAUConstructorSparseEx {
    private final HashMap<String, SFormsFastMapDirect> inVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> outVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> outNegVarVersions = new HashMap();
    private final HashMap<String, SFormsFastMapDirect> extraVarVersions = new HashMap();
    private final HashMap<Integer, Integer> lastversion = new HashMap();
    private final HashMap<VarVersionPair, Integer> mapVersionFirstRange = new HashMap();
    private final HashMap<VarVersionPair, VarVersionPair> phantomppnodes = new HashMap();
    private final HashMap<String, HashMap<VarVersionPair, VarVersionPair>> phantomexitnodes = new HashMap();
    private final VarVersionsGraph ssuversions = new VarVersionsGraph();
    private final HashMap<Integer, Integer> mapFieldVars = new HashMap();
    private int fieldvarcounter = -1;
    private FastSparseSetFactory<Integer> factory;

    public void splitVariables(RootStatement root, StructMethod mt) {
        FlattenStatementsHelper flatthelper = new FlattenStatementsHelper();
        DirectGraph dgraph = flatthelper.buildDirectGraph(root);
        HashSet<Integer> setInit = new HashSet<Integer>();
        for (int i = 0; i < 64; ++i) {
            setInit.add(i);
        }
        this.factory = new FastSparseSetFactory(setInit);
        this.extraVarVersions.put(dgraph.first.id, this.createFirstMap(mt, root));
        this.setCatchMaps(root, dgraph, flatthelper);
        HashSet<String> updated = new HashSet<String>();
        do {
            this.ssaStatements(dgraph, updated, false);
        } while (!updated.isEmpty());
        this.ssaStatements(dgraph, updated, true);
        this.ssuversions.initDominators();
    }

    private void ssaStatements(DirectGraph dgraph, HashSet<String> updated, boolean calcLiveVars) {
        for (DirectNode node : dgraph.nodes) {
            boolean this_updated;
            boolean allow_field_propagation;
            updated.remove(node.id);
            this.mergeInVarMaps(node, dgraph);
            SFormsFastMapDirect varmap = new SFormsFastMapDirect(this.inVarVersions.get(node.id));
            SFormsFastMapDirect[] varmaparr = new SFormsFastMapDirect[]{varmap, null};
            if (node.exprents != null) {
                for (Exprent expr : node.exprents) {
                    this.processExprent(expr, varmaparr, node.statement, calcLiveVars);
                }
            }
            if (varmaparr[1] == null) {
                varmaparr[1] = varmaparr[0];
            }
            boolean bl = allow_field_propagation = node.successors.isEmpty() || node.successors.size() == 1 && node.successors.get((int)0).predecessors.size() == 1;
            if (!allow_field_propagation && varmaparr[0] != null) {
                varmaparr[0].removeAllFields();
                varmaparr[1].removeAllFields();
            }
            if (!(this_updated = !SSAUConstructorSparseEx.mapsEqual(varmaparr[0], this.outVarVersions.get(node.id)) || this.outNegVarVersions.containsKey(node.id) && !SSAUConstructorSparseEx.mapsEqual(varmaparr[1], this.outNegVarVersions.get(node.id)))) continue;
            this.outVarVersions.put(node.id, varmaparr[0]);
            if (dgraph.mapNegIfBranch.containsKey(node.id)) {
                this.outNegVarVersions.put(node.id, varmaparr[1]);
            }
            for (DirectNode nd : node.successors) {
                updated.add(nd.id);
            }
        }
    }

    private void processExprent(Exprent expr, SFormsFastMapDirect[] varmaparr, Statement stat, boolean calcLiveVars) {
        if (expr == null) {
            return;
        }
        VarExprent varassign = null;
        boolean finished = false;
        block0 : switch (expr.type) {
            case 2: {
                AssignmentExprent assexpr = (AssignmentExprent)expr;
                if (assexpr.getCondType() != -1) break;
                Exprent dest = assexpr.getLeft();
                if (dest.type != 12) break;
                varassign = (VarExprent)dest;
                break;
            }
            case 6: {
                FunctionExprent func = (FunctionExprent)expr;
                switch (func.getFuncType()) {
                    case 36: {
                        SFormsFastMapDirect varmapFalse;
                        this.processExprent(func.getLstOperands().get(0), varmaparr, stat, calcLiveVars);
                        if (varmaparr[1] == null) {
                            varmapFalse = new SFormsFastMapDirect(varmaparr[0]);
                        } else {
                            varmapFalse = varmaparr[1];
                            varmaparr[1] = null;
                        }
                        this.processExprent(func.getLstOperands().get(1), varmaparr, stat, calcLiveVars);
                        SFormsFastMapDirect[] varmaparrNeg = new SFormsFastMapDirect[]{varmapFalse, null};
                        this.processExprent(func.getLstOperands().get(2), varmaparrNeg, stat, calcLiveVars);
                        SSAUConstructorSparseEx.mergeMaps(varmaparr[0], varmaparrNeg[0]);
                        varmaparr[1] = null;
                        finished = true;
                        break block0;
                    }
                    case 48: {
                        this.processExprent(func.getLstOperands().get(0), varmaparr, stat, calcLiveVars);
                        SFormsFastMapDirect[] varmaparrAnd = new SFormsFastMapDirect[]{new SFormsFastMapDirect(varmaparr[0]), null};
                        this.processExprent(func.getLstOperands().get(1), varmaparrAnd, stat, calcLiveVars);
                        varmaparr[1] = SSAUConstructorSparseEx.mergeMaps(varmaparr[varmaparr[1] == null ? 0 : 1], varmaparrAnd[varmaparrAnd[1] == null ? 0 : 1]);
                        varmaparr[0] = varmaparrAnd[0];
                        finished = true;
                        break block0;
                    }
                    case 49: {
                        this.processExprent(func.getLstOperands().get(0), varmaparr, stat, calcLiveVars);
                        SFormsFastMapDirect[] varmaparrOr = new SFormsFastMapDirect[]{new SFormsFastMapDirect(varmaparr[varmaparr[1] == null ? 0 : 1]), null};
                        this.processExprent(func.getLstOperands().get(1), varmaparrOr, stat, calcLiveVars);
                        varmaparr[1] = varmaparrOr[varmaparrOr[1] == null ? 0 : 1];
                        varmaparr[0] = SSAUConstructorSparseEx.mergeMaps(varmaparr[0], varmaparrOr[0]);
                        finished = true;
                    }
                }
            }
        }
        if (!finished) {
            List<Exprent> lst = expr.getAllExprents();
            lst.remove(varassign);
            for (Exprent ex : lst) {
                this.processExprent(ex, varmaparr, stat, calcLiveVars);
            }
        }
        SFormsFastMapDirect varmap = varmaparr[0];
        if (expr.type == 5) {
            int index;
            if (this.mapFieldVars.containsKey(expr.id)) {
                index = this.mapFieldVars.get(expr.id);
            } else {
                index = this.fieldvarcounter--;
                this.mapFieldVars.put(expr.id, index);
                this.ssuversions.createNode(new VarVersionPair(index, 1));
            }
            this.setCurrentVar(varmap, index, 1);
        } else if (expr.type == 8 || expr.type == 2 && ((AssignmentExprent)expr).getLeft().type == 5 || expr.type == 10 && ((NewExprent)expr).getNewType().getType() == 8 || expr.type == 6) {
            boolean ismmpp = true;
            if (expr.type == 6) {
                ismmpp = false;
                FunctionExprent fexpr = (FunctionExprent)expr;
                if (fexpr.getFuncType() >= 32 && fexpr.getFuncType() <= 35 && fexpr.getLstOperands().get((int)0).type == 5) {
                    ismmpp = true;
                }
            }
            if (ismmpp) {
                varmap.removeAllFields();
            }
        }
        if (varassign != null) {
            Integer varindex = varassign.getIndex();
            if (varassign.getVersion() == 0) {
                Integer nextver = this.getNextFreeVersion(varindex, stat);
                varassign.setVersion(nextver);
                this.ssuversions.createNode(new VarVersionPair(varindex, nextver));
                this.setCurrentVar(varmap, varindex, nextver);
            } else {
                if (calcLiveVars) {
                    this.varMapToGraph(new VarVersionPair((int)varindex, varassign.getVersion()), varmap);
                }
                this.setCurrentVar(varmap, varindex, varassign.getVersion());
            }
        } else if (expr.type == 6) {
            FunctionExprent func = (FunctionExprent)expr;
            switch (func.getFuncType()) {
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    if (func.getLstOperands().get((int)0).type != 12) break;
                    VarExprent var = (VarExprent)func.getLstOperands().get(0);
                    Integer varindex = var.getIndex();
                    VarVersionPair varpaar = new VarVersionPair((int)varindex, var.getVersion());
                    VarVersionPair phantomver = this.phantomppnodes.get(varpaar);
                    if (phantomver == null) {
                        Integer nextver = this.getNextFreeVersion(varindex, null);
                        phantomver = new VarVersionPair(varindex, nextver);
                        this.ssuversions.createNode(phantomver);
                        VarVersionNode vernode = this.ssuversions.nodes.getWithKey(varpaar);
                        FastSparseSetFactory.FastSparseSet<Integer> vers = this.factory.spawnEmptySet();
                        if (vernode.predecessors.size() == 1) {
                            vers.add(vernode.predecessors.iterator().next().source.version);
                        } else {
                            for (VarVersionEdge edge : vernode.predecessors) {
                                vers.add(edge.source.predecessors.iterator().next().source.version);
                            }
                        }
                        vers.add(nextver);
                        this.createOrUpdatePhiNode(varpaar, vers, stat);
                        this.phantomppnodes.put(varpaar, phantomver);
                    }
                    if (calcLiveVars) {
                        this.varMapToGraph(varpaar, varmap);
                    }
                    this.setCurrentVar(varmap, varindex, var.getVersion());
                }
            }
        } else if (expr.type == 12) {
            VarExprent vardest = (VarExprent)expr;
            Integer varindex = vardest.getIndex();
            Integer current_vers = vardest.getVersion();
            FastSparseSetFactory.FastSparseSet<Integer> vers = varmap.get(varindex);
            int cardinality = vers.getCardinality();
            if (cardinality == 1) {
                if (current_vers != 0) {
                    if (calcLiveVars) {
                        this.varMapToGraph(new VarVersionPair(varindex, current_vers), varmap);
                    }
                    this.setCurrentVar(varmap, varindex, current_vers);
                } else {
                    Integer usever = this.getNextFreeVersion(varindex, stat);
                    vardest.setVersion(usever);
                    this.setCurrentVar(varmap, varindex, usever);
                    Integer lastver = vers.iterator().next();
                    VarVersionNode prenode = this.ssuversions.nodes.getWithKey(new VarVersionPair(varindex, lastver));
                    VarVersionNode usenode = this.ssuversions.createNode(new VarVersionPair(varindex, usever));
                    VarVersionEdge edge = new VarVersionEdge(0, prenode, usenode);
                    prenode.addSuccessor(edge);
                    usenode.addPredecessor(edge);
                }
            } else if (cardinality == 2) {
                if (current_vers != 0) {
                    if (calcLiveVars) {
                        this.varMapToGraph(new VarVersionPair(varindex, current_vers), varmap);
                    }
                    this.setCurrentVar(varmap, varindex, current_vers);
                } else {
                    Integer usever = this.getNextFreeVersion(varindex, stat);
                    vardest.setVersion(usever);
                    this.ssuversions.createNode(new VarVersionPair(varindex, usever));
                    this.setCurrentVar(varmap, varindex, usever);
                    current_vers = usever;
                }
                this.createOrUpdatePhiNode(new VarVersionPair(varindex, current_vers), vers, stat);
            }
        }
    }

    private void createOrUpdatePhiNode(VarVersionPair phivar, FastSparseSetFactory.FastSparseSet<Integer> vers, Statement stat) {
        FastSparseSetFactory.FastSparseSet<Integer> versCopy = vers.getCopy();
        int ppvers = this.phantomppnodes.containsKey(phivar) ? this.phantomppnodes.get((Object)phivar).version : -1;
        VarVersionNode phinode = this.ssuversions.nodes.getWithKey(phivar);
        ArrayList<VarVersionEdge> lstPreds = new ArrayList<VarVersionEdge>(phinode.predecessors);
        if (lstPreds.size() == 1) {
            VarVersionEdge edge = (VarVersionEdge)lstPreds.get(0);
            edge.source.removeSuccessor(edge);
            phinode.removePredecessor(edge);
        } else {
            for (VarVersionEdge edge : lstPreds) {
                int verssrc = edge.source.predecessors.iterator().next().source.version;
                if (!vers.contains(verssrc) && verssrc != ppvers) {
                    edge.source.removeSuccessor(edge);
                    phinode.removePredecessor(edge);
                    continue;
                }
                versCopy.remove(verssrc);
            }
        }
        ArrayList<VarVersionNode> colnodes = new ArrayList<VarVersionNode>();
        ArrayList<VarVersionPair> colpaars = new ArrayList<VarVersionPair>();
        for (Integer ver : versCopy) {
            VarVersionNode prenode = this.ssuversions.nodes.getWithKey(new VarVersionPair(phivar.var, (int)ver));
            Integer tempver = this.getNextFreeVersion(phivar.var, stat);
            VarVersionNode tempnode = new VarVersionNode(phivar.var, tempver);
            colnodes.add(tempnode);
            colpaars.add(new VarVersionPair(phivar.var, (int)tempver));
            VarVersionEdge edge = new VarVersionEdge(0, prenode, tempnode);
            prenode.addSuccessor(edge);
            tempnode.addPredecessor(edge);
            edge = new VarVersionEdge(0, tempnode, phinode);
            tempnode.addSuccessor(edge);
            phinode.addPredecessor(edge);
        }
        this.ssuversions.addNodes(colnodes, colpaars);
    }

    private void varMapToGraph(VarVersionPair varpaar, SFormsFastMapDirect varmap) {
        VBStyleCollection<VarVersionNode, VarVersionPair> nodes = this.ssuversions.nodes;
        VarVersionNode node = nodes.getWithKey(varpaar);
        node.live = new SFormsFastMapDirect(varmap);
    }

    private Integer getNextFreeVersion(Integer var, Statement stat) {
        Integer firstRangeId;
        Integer nextver = this.lastversion.get(var);
        if (nextver == null) {
            nextver = 1;
        } else {
            Integer n = nextver;
            nextver = nextver + 1;
        }
        this.lastversion.put(var, nextver);
        if (stat != null && (firstRangeId = SSAUConstructorSparseEx.getFirstProtectedRange(stat)) != null) {
            this.mapVersionFirstRange.put(new VarVersionPair(var, nextver), firstRangeId);
        }
        return nextver;
    }

    private void mergeInVarMaps(DirectNode node, DirectGraph dgraph) {
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect();
        for (DirectNode pred : node.predecessors) {
            SFormsFastMapDirect mapOut = this.getFilteredOutMap(node.id, pred.id, dgraph, node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapOut.getCopy();
                continue;
            }
            SSAUConstructorSparseEx.mergeMaps(mapNew, mapOut);
        }
        if (this.extraVarVersions.containsKey(node.id)) {
            SFormsFastMapDirect mapExtra = this.extraVarVersions.get(node.id);
            if (mapNew.isEmpty()) {
                mapNew = mapExtra.getCopy();
            } else {
                SSAUConstructorSparseEx.mergeMaps(mapNew, mapExtra);
            }
        }
        this.inVarVersions.put(node.id, mapNew);
    }

    private SFormsFastMapDirect getFilteredOutMap(String nodeid, String predid, DirectGraph dgraph, String destid) {
        SFormsFastMapDirect mapNew = new SFormsFastMapDirect();
        boolean isFinallyExit = dgraph.mapShortRangeFinallyPaths.containsKey(predid);
        if (nodeid.equals(dgraph.mapNegIfBranch.get(predid))) {
            if (this.outNegVarVersions.containsKey(predid)) {
                mapNew = this.outNegVarVersions.get(predid).getCopy();
            }
        } else if (this.outVarVersions.containsKey(predid)) {
            mapNew = this.outVarVersions.get(predid).getCopy();
        }
        if (isFinallyExit) {
            SFormsFastMapDirect mapNewTemp = mapNew.getCopy();
            SFormsFastMapDirect mapTrueSource = new SFormsFastMapDirect();
            String exceptionDest = dgraph.mapFinallyMonitorExceptionPathExits.get(predid);
            boolean isExceptionMonitorExit = exceptionDest != null && !nodeid.equals(exceptionDest);
            HashSet<CallSite> setLongPathWrapper = new HashSet<CallSite>();
            for (List<FlattenStatementsHelper.FinallyPathWrapper> lstwrapper : dgraph.mapLongRangeFinallyPaths.values()) {
                for (FlattenStatementsHelper.FinallyPathWrapper finallyPathWrapper : lstwrapper) {
                    setLongPathWrapper.add((CallSite)((Object)(finallyPathWrapper.destination + "##" + finallyPathWrapper.source)));
                }
            }
            for (FlattenStatementsHelper.FinallyPathWrapper finwrap : dgraph.mapShortRangeFinallyPaths.get(predid)) {
                boolean isFalsePath;
                boolean bl = dgraph.mapShortRangeFinallyPaths.containsKey(finwrap.source);
                SFormsFastMapDirect map = bl ? this.getFilteredOutMap(finwrap.entry, finwrap.source, dgraph, destid) : (finwrap.entry.equals(dgraph.mapNegIfBranch.get(finwrap.source)) ? this.outNegVarVersions.get(finwrap.source) : this.outVarVersions.get(finwrap.source));
                if (bl) {
                    isFalsePath = !finwrap.destination.equals(nodeid);
                } else {
                    boolean bl2 = isFalsePath = !setLongPathWrapper.contains(destid + "##" + finwrap.source);
                }
                if (isFalsePath) {
                    mapNewTemp.complement(map);
                    continue;
                }
                if (mapTrueSource.isEmpty()) {
                    if (map == null) continue;
                    mapTrueSource = map.getCopy();
                    continue;
                }
                SSAUConstructorSparseEx.mergeMaps(mapTrueSource, map);
            }
            if (isExceptionMonitorExit) {
                mapNew = mapTrueSource;
            } else {
                mapNewTemp.union(mapTrueSource);
                mapNew.intersection(mapNewTemp);
                if (!mapTrueSource.isEmpty() && !mapNew.isEmpty()) {
                    HashMap<VarVersionPair, VarVersionPair> mapPhantom = this.phantomexitnodes.get(predid);
                    if (mapPhantom == null) {
                        mapPhantom = new HashMap();
                    }
                    SFormsFastMapDirect mapExitVar = mapNew.getCopy();
                    mapExitVar.complement(mapTrueSource);
                    for (Map.Entry entry : mapExitVar.entryList()) {
                        for (Integer version : (FastSparseSetFactory.FastSparseSet)entry.getValue()) {
                            Integer varindex = (Integer)entry.getKey();
                            VarVersionPair exitvar = new VarVersionPair(varindex, version);
                            FastSparseSetFactory.FastSparseSet<Integer> newSet = mapNew.get(varindex);
                            newSet.remove(version);
                            VarVersionPair phantomvar = mapPhantom.get(exitvar);
                            if (phantomvar == null) {
                                Integer newversion = this.getNextFreeVersion(exitvar.var, null);
                                phantomvar = new VarVersionPair(exitvar.var, (int)newversion);
                                VarVersionNode exitnode = this.ssuversions.nodes.getWithKey(exitvar);
                                VarVersionNode phantomnode = this.ssuversions.createNode(phantomvar);
                                phantomnode.flags |= 2;
                                VarVersionEdge edge = new VarVersionEdge(1, exitnode, phantomnode);
                                exitnode.addSuccessor(edge);
                                phantomnode.addPredecessor(edge);
                                mapPhantom.put(exitvar, phantomvar);
                            }
                            newSet.add(phantomvar.version);
                        }
                    }
                    if (!mapPhantom.isEmpty()) {
                        this.phantomexitnodes.put(predid, mapPhantom);
                    }
                }
            }
        }
        return mapNew;
    }

    private static SFormsFastMapDirect mergeMaps(SFormsFastMapDirect mapTo, SFormsFastMapDirect map2) {
        if (map2 != null && !map2.isEmpty()) {
            mapTo.union(map2);
        }
        return mapTo;
    }

    private static boolean mapsEqual(SFormsFastMapDirect map1, SFormsFastMapDirect map2) {
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<Integer, FastSparseSetFactory.FastSparseSet<Integer>> ent2 : map2.entryList()) {
            if (Objects.equals(map1.get(ent2.getKey()), ent2.getValue())) continue;
            return false;
        }
        return true;
    }

    private void setCurrentVar(SFormsFastMapDirect varmap, Integer var, Integer vers) {
        FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.spawnEmptySet();
        set.add(vers);
        varmap.put(var, set);
    }

    private void setCatchMaps(Statement stat, DirectGraph dgraph, FlattenStatementsHelper flatthelper) {
        switch (stat.type) {
            case CATCH_ALL: 
            case TRY_CATCH: {
                List<VarExprent> lstVars = stat.type == Statement.StatementType.CATCH_ALL ? ((CatchAllStatement)stat).getVars() : ((CatchStatement)stat).getVars();
                for (int i = 1; i < stat.getStats().size(); ++i) {
                    int varindex = lstVars.get(i - 1).getIndex();
                    int version = this.getNextFreeVersion(varindex, stat);
                    SFormsFastMapDirect map = new SFormsFastMapDirect();
                    this.setCurrentVar(map, varindex, version);
                    this.extraVarVersions.put(dgraph.nodes.getWithKey((String)flatthelper.getMapDestinationNodes().get((Object)Integer.valueOf((int)((Statement)stat.getStats().get((int)i)).id))[0]).id, map);
                    this.ssuversions.createNode(new VarVersionPair(varindex, version));
                }
                break;
            }
        }
        for (Statement st : stat.getStats()) {
            this.setCatchMaps(st, dgraph, flatthelper);
        }
    }

    private SFormsFastMapDirect createFirstMap(StructMethod mt, RootStatement root) {
        boolean thisvar = !mt.hasModifier(8);
        MethodDescriptor md = MethodDescriptor.parseDescriptor(mt.getDescriptor());
        int paramcount = md.params.length + (thisvar ? 1 : 0);
        int varindex = 0;
        SFormsFastMapDirect map = new SFormsFastMapDirect();
        for (int i = 0; i < paramcount; ++i) {
            int version = this.getNextFreeVersion(varindex, root);
            FastSparseSetFactory.FastSparseSet<Integer> set = this.factory.spawnEmptySet();
            set.add(version);
            map.put(varindex, set);
            this.ssuversions.createNode(new VarVersionPair(varindex, version));
            if (thisvar) {
                if (i == 0) {
                    ++varindex;
                    continue;
                }
                varindex += md.params[i - 1].getStackSize();
                continue;
            }
            varindex += md.params[i].getStackSize();
        }
        return map;
    }

    private static Integer getFirstProtectedRange(Statement stat) {
        Statement parent;
        while ((parent = stat.getParent()) != null) {
            if (parent.type == Statement.StatementType.CATCH_ALL || parent.type == Statement.StatementType.TRY_CATCH ? parent.getFirst() == stat : parent.type == Statement.StatementType.SYNCHRONIZED && ((SynchronizedStatement)parent).getBody() == stat) {
                return parent.id;
            }
            stat = parent;
        }
        return null;
    }

    public VarVersionsGraph getSsuversions() {
        return this.ssuversions;
    }

    public SFormsFastMapDirect getLiveVarVersionsMap(VarVersionPair varpaar) {
        VarVersionNode node = this.ssuversions.nodes.getWithKey(varpaar);
        if (node != null) {
            return node.live;
        }
        return null;
    }

    public HashMap<VarVersionPair, Integer> getMapVersionFirstRange() {
        return this.mapVersionFirstRange;
    }

    public HashMap<Integer, Integer> getMapFieldVars() {
        return this.mapFieldVars;
    }
}

