/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class DirectNode {
    @NotNull
    public final DirectNodeType type;
    @NotNull
    public final String id;
    @NotNull
    public final Statement statement;
    @Nullable
    public final BasicBlockStatement block;
    public final List<DirectNode> successors = new ArrayList<DirectNode>();
    public final List<DirectNode> predecessors = new ArrayList<DirectNode>();
    public List<Exprent> exprents = new ArrayList<Exprent>();

    public DirectNode(@NotNull DirectNodeType type, @NotNull Statement statement, @NotNull String id) {
        this.type = type;
        this.statement = statement;
        this.id = id;
        this.block = null;
    }

    public DirectNode(@NotNull DirectNodeType type, @NotNull Statement statement, @NotNull BasicBlockStatement block) {
        this.type = type;
        this.statement = statement;
        this.id = Integer.toString(block.id);
        this.block = block;
    }

    public String toString() {
        return this.id;
    }

    public static enum DirectNodeType {
        DIRECT,
        TAIL,
        INIT,
        CONDITION,
        INCREMENT,
        TRY;

    }
}

