/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;

public class StatEdge {
    @NotNull
    private EdgeType type;
    private Statement source;
    private Statement destination;
    private List<String> exceptions;
    public Statement closure;
    public boolean labeled = true;
    public boolean explicit = true;

    public StatEdge(@NotNull EdgeType type, Statement source, Statement destination, Statement closure) {
        this(type, source, destination);
        this.closure = closure;
    }

    public StatEdge(@NotNull EdgeType type, Statement source, Statement destination) {
        this.type = type;
        this.source = source;
        this.destination = destination;
    }

    public StatEdge(Statement source, Statement destination, List<String> exceptions) {
        this(EdgeType.EXCEPTION, source, destination);
        if (exceptions != null) {
            this.exceptions = new ArrayList<String>(exceptions);
        }
    }

    @NotNull
    public EdgeType getType() {
        return this.type;
    }

    public void setType(@NotNull EdgeType type) {
        this.type = type;
    }

    public Statement getSource() {
        return this.source;
    }

    public void setSource(Statement source) {
        this.source = source;
    }

    public Statement getDestination() {
        return this.destination;
    }

    public void setDestination(Statement destination) {
        this.destination = destination;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public static interface EdgeType {
        public static final EdgeType REGULAR = new EdgeType(){

            @Override
            public int mask() {
                return 1;
            }

            public String toString() {
                return "REGULAR";
            }
        };
        public static final EdgeType EXCEPTION = new EdgeType(){

            @Override
            public int mask() {
                return 2;
            }

            public String toString() {
                return "EXCEPTION";
            }
        };
        public static final EdgeType BREAK = new EdgeType(){

            @Override
            public int mask() {
                return 4;
            }

            public String toString() {
                return "BREAK";
            }
        };
        public static final EdgeType CONTINUE = new EdgeType(){

            @Override
            public int mask() {
                return 8;
            }

            public String toString() {
                return "CONTINUE";
            }
        };
        public static final EdgeType FINALLY_EXIT = new EdgeType(){

            @Override
            public int mask() {
                return 32;
            }

            public String toString() {
                return "FINALLY_EXIT";
            }
        };
        public static final EdgeType ALL = new EdgeType(){

            @Override
            public int mask() {
                return Integer.MIN_VALUE;
            }

            @Override
            @NotNull
            public EdgeType unite(@NotNull EdgeType other) {
                return this;
            }

            public String toString() {
                return "ALL";
            }
        };
        public static final EdgeType DIRECT_ALL = new EdgeType(){

            @Override
            public int mask() {
                return 0x40000000;
            }

            @Override
            @NotNull
            public EdgeType unite(@NotNull EdgeType other) {
                return this;
            }

            public String toString() {
                return "DIRECT_ALL";
            }
        };
        public static final EdgeType NULL = new EdgeType(){

            @Override
            public int mask() {
                return -1;
            }

            @Override
            @NotNull
            public EdgeType unite(@NotNull EdgeType other) {
                throw new UnsupportedOperationException("Union operation is not supported for NULL edge type");
            }
        };

        public int mask();

        @NotNull
        default public EdgeType unite(final @NotNull EdgeType other) {
            return new EdgeType(){

                @Override
                public int mask() {
                    return this.mask() | other.mask();
                }
            };
        }

        public static EdgeType[] types() {
            return new EdgeType[]{REGULAR, EXCEPTION, BREAK, CONTINUE, FINALLY_EXIT};
        }
    }

    public static enum EdgeDirection {
        BACKWARD,
        FORWARD;

    }
}

