/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.main.rels;

import java.io.IOException;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.modules.code.DeadCodeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ClearStructHelper;
import org.jetbrains.java.decompiler.modules.decompiler.DomHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExitHelper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.FinallyProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.IdeaNotNullHelper;
import org.jetbrains.java.decompiler.modules.decompiler.IfHelper;
import org.jetbrains.java.decompiler.modules.decompiler.InlineSingleBlockHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LabelHelper;
import org.jetbrains.java.decompiler.modules.decompiler.LoopExtractHelper;
import org.jetbrains.java.decompiler.modules.decompiler.MergeHelper;
import org.jetbrains.java.decompiler.modules.decompiler.PPandMMHelper;
import org.jetbrains.java.decompiler.modules.decompiler.PatternHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SecondaryFunctionsHelper;
import org.jetbrains.java.decompiler.modules.decompiler.SequenceHelper;
import org.jetbrains.java.decompiler.modules.decompiler.StackVarsProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.SwitchHelper;
import org.jetbrains.java.decompiler.modules.decompiler.deobfuscator.ExceptionDeobfuscator;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.vars.VarProcessor;
import org.jetbrains.java.decompiler.struct.StructClass;
import org.jetbrains.java.decompiler.struct.StructMethod;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;

public class MethodProcessorRunnable
implements Runnable {
    public final Object lock = new Object();
    private final StructClass klass;
    private final StructMethod method;
    private final MethodDescriptor methodDescriptor;
    private final VarProcessor varProc;
    private final DecompilerContext parentContext;
    private volatile RootStatement root;
    private volatile Throwable error;
    private volatile boolean finished = false;

    public MethodProcessorRunnable(StructClass klass, StructMethod method, MethodDescriptor methodDescriptor, VarProcessor varProc, DecompilerContext parentContext) {
        this.klass = klass;
        this.method = method;
        this.methodDescriptor = methodDescriptor;
        this.varProc = varProc;
        this.parentContext = parentContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.error = null;
        this.root = null;
        try {
            DecompilerContext.setCurrentContext(this.parentContext);
            this.root = MethodProcessorRunnable.codeToJava(this.klass, this.method, this.methodDescriptor, this.varProc);
        }
        catch (Throwable t) {
            this.error = t;
        }
        finally {
            DecompilerContext.setCurrentContext(null);
        }
        this.finished = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    public static RootStatement codeToJava(StructClass cl, StructMethod mt, MethodDescriptor md, VarProcessor varProc) throws IOException {
        boolean isInitializer = "<clinit>".equals(mt.getName());
        mt.expandData(cl);
        InstructionSequence seq = mt.getInstructionSequence();
        ControlFlowGraph graph = new ControlFlowGraph(seq);
        DeadCodeHelper.removeDeadBlocks(graph);
        if (!cl.isVersion7()) {
            graph.inlineJsr(cl, mt);
        }
        DeadCodeHelper.connectDummyExitBlock(graph);
        DeadCodeHelper.removeGoTos(graph);
        ExceptionDeobfuscator.removeCircularRanges(graph);
        ExceptionDeobfuscator.restorePopRanges(graph);
        if (DecompilerContext.getOption("rer")) {
            ExceptionDeobfuscator.removeEmptyRanges(graph);
        }
        if (DecompilerContext.getOption("esm")) {
            DeadCodeHelper.extendSynchronizedRangeToMonitorExit(graph);
        }
        if (DecompilerContext.getOption("ner")) {
            DeadCodeHelper.incorporateValueReturns(graph);
        }
        ExceptionDeobfuscator.insertEmptyExceptionHandlerBlocks(graph);
        DeadCodeHelper.mergeBasicBlocks(graph);
        DecompilerContext.getCounterContainer().setCounter(2, mt.getLocalVariables());
        if (ExceptionDeobfuscator.hasObfuscatedExceptions(graph)) {
            DecompilerContext.getLogger().writeMessage("Heavily obfuscated exception ranges found!", IFernflowerLogger.Severity.WARN);
            if (!ExceptionDeobfuscator.handleMultipleEntryExceptionRanges(graph)) {
                DecompilerContext.getLogger().writeMessage("Found multiple entry exception ranges which could not be splitted", IFernflowerLogger.Severity.WARN);
            }
            ExceptionDeobfuscator.insertDummyExceptionHandlerBlocks(graph, mt.getBytecodeVersion());
        }
        RootStatement root = DomHelper.parseGraph(graph);
        FinallyProcessor fProc = new FinallyProcessor(md, varProc);
        while (fProc.iterateGraph(cl, mt, root, graph)) {
            root = DomHelper.parseGraph(graph);
        }
        DomHelper.removeSynchronizedHandler(root);
        SequenceHelper.condenseSequences(root);
        ClearStructHelper.clearStatements(root);
        ExprProcessor proc = new ExprProcessor(md, varProc);
        proc.processStatement(root, cl);
        SequenceHelper.condenseSequences(root);
        StackVarsProcessor stackProc = new StackVarsProcessor();
        do {
            stackProc.simplifyStackVars(root, mt, cl);
            varProc.setVarVersions(root);
        } while (new PPandMMHelper().findPPandMM(root));
        do {
            LabelHelper.cleanUpEdges(root);
            do {
                MergeHelper.enhanceLoops(root);
            } while (LoopExtractHelper.extractLoops(root) || IfHelper.mergeAllIfs(root));
            if (DecompilerContext.getOption("inn") && IdeaNotNullHelper.removeHardcodedChecks(root, mt)) {
                SequenceHelper.condenseSequences(root);
                stackProc.simplifyStackVars(root, mt, cl);
                varProc.setVarVersions(root);
            }
            LabelHelper.identifyLabels(root);
        } while (InlineSingleBlockHelper.inlineSingleBlocks(root) || !isInitializer && ExitHelper.condenseExits(root));
        ExitHelper.removeRedundantReturns(root);
        SecondaryFunctionsHelper.identifySecondaryFunctions(root, varProc);
        varProc.setVarDefinitions(root);
        LabelHelper.replaceContinueWithBreak(root);
        PatternHelper.replaceAssignmentsWithPatternVariables(root, cl);
        SwitchHelper.simplifySwitchesOnString(root);
        mt.releaseResources();
        return root;
    }

    public RootStatement getResult() throws Throwable {
        Throwable t = this.error;
        if (t != null) {
            throw t;
        }
        return this.root;
    }

    public boolean isFinished() {
        return this.finished;
    }
}

