/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import com.intellij.util.containers.EmptyIterator;
import com.intellij.util.containers.EmptyListIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Deprecated
@ApiStatus.ScheduledForRemoval
public final class ContainerUtilRt {
    @Deprecated
    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> ArrayList<T> newArrayList(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(T ... elements) {
        return new LinkedHashSet<T>(Arrays.asList(elements));
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        return EmptyList.INSTANCE;
    }

    @Deprecated
    @NotNull
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection.isEmpty()) {
            return ContainerUtilRt.emptyList();
        }
        ArrayList<V> list = new ArrayList<V>(collection.size());
        for (T t : collection) {
            list.add(mapper.fun(t));
        }
        return list;
    }

    private static final class EmptyList<T>
    extends AbstractList<T>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final EmptyList<?> INSTANCE = new EmptyList();

        private EmptyList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public T get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public <E> E[] toArray(@NotNull E[] a) {
            if (a.length != 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        @NotNull
        public Iterator<T> iterator() {
            return EmptyIterator.getInstance();
        }

        @Override
        @NotNull
        public ListIterator<T> listIterator() {
            return EmptyListIterator.getInstance();
        }

        @Override
        public boolean containsAll(@NotNull Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        @Contract(pure=true)
        public boolean isEmpty() {
            return true;
        }

        @Override
        @Contract(pure=true)
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }
    }
}

