/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.PrivateKeyReader;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SslUtil {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    public static final String SSL_USE_FACTORY = "sslUseFactory";
    private static final String END_CERTIFICATE = "-----END CERTIFICATE-----";

    @NotNull
    public static List<X509Certificate> loadCertificates(@NotNull String caCertPath) throws IOException, CertificateException {
        String string = FileUtilRt.loadFile(new File(caCertPath));
        String[] tokens = string.split(END_CERTIFICATE);
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>(tokens.length);
        for (String token : tokens) {
            if (token == null || token.trim().length() == 0) continue;
            certs.add(SslUtil.readCertificate(SslUtil.stringStream(token + END_CERTIFICATE)));
        }
        return certs;
    }

    @NotNull
    public static InputStream stringStream(@NotNull String str) {
        try {
            return new ByteArrayInputStream(str.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        return SslUtil.readCertificate(new FileInputStream(filePath));
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull InputStream stream) throws CertificateException, IOException {
        X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
        stream.close();
        return certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        return SslUtil.readPrivateKey(filePath, null);
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath, @Nullable char[] password) throws IOException {
        return new PrivateKeyReader(filePath, password).getPrivateKey();
    }

    static class TrustEverybodyManager
    implements X509TrustManager {
        TrustEverybodyManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

