/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.util.lang.Loader;
import com.intellij.util.lang.UrlClassLoader;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

final class JointCompilationClassLoader
extends UrlClassLoader {
    private static final boolean isParallelCapable = JointCompilationClassLoader.registerAsParallelCapable();

    JointCompilationClassLoader(@NotNull UrlClassLoader.Builder builder) {
        super(builder, isParallelCapable);
    }

    public Class<?> consumeClassData(@NotNull String name, byte[] data, Loader loader) {
        try {
            return super.consumeClassData(name, data, loader);
        }
        catch (Exception e) {
            NoClassDefFoundError wrap = new NoClassDefFoundError(e.getMessage() + " needed for " + name);
            wrap.initCause(e);
            throw wrap;
        }
    }

    public Class<?> consumeClassData(@NotNull String name, ByteBuffer data, Loader loader) {
        try {
            return super.consumeClassData(name, data, loader);
        }
        catch (Exception e) {
            NoClassDefFoundError wrap = new NoClassDefFoundError(e.getMessage() + " needed for " + name);
            wrap.initCause(e);
            throw wrap;
        }
    }

    void resetCache() {
        this.getClassPath().reset(this.getFiles());
    }
}

