/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.groovy.compiler.rt.OutputItem;
import org.jetbrains.jps.incremental.groovy.JpsGroovycRunner;
import org.jetbrains.jps.incremental.messages.CompilerMessage;

public final class GroovyCompilerResult {
    private final List<OutputItem> myCompiledItems;
    private final List<? extends CompilerMessage> myCompilerMessages;

    public GroovyCompilerResult(@NotNull @NotNull Collection<@NotNull OutputItem> items, @NotNull @NotNull Collection<? extends @NotNull CompilerMessage> messages) {
        this.myCompiledItems = new ArrayList<OutputItem>(items);
        this.myCompilerMessages = new ArrayList<CompilerMessage>(messages);
    }

    @NotNull
    public @NotNull List<@NotNull OutputItem> getSuccessfullyCompiled() {
        return this.myCompiledItems;
    }

    @NotNull
    public @NotNull List<? extends @NotNull CompilerMessage> getCompilerMessages() {
        return this.myCompilerMessages;
    }

    public boolean shouldRetry() {
        for (CompilerMessage compilerMessage : this.myCompilerMessages) {
            String text = compilerMessage.getMessageText();
            if (!text.contains("java.lang.NoClassDefFoundError") && !text.contains("java.lang.TypeNotPresentException") && !text.contains("unable to resolve class")) continue;
            JpsGroovycRunner.LOG.debug("Resolve issue: " + compilerMessage);
            return true;
        }
        return false;
    }
}

