/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.colorspace;

import androidx.compose.ui.graphics.colorspace.ColorModel;
import androidx.compose.ui.graphics.colorspace.ColorSpace;
import androidx.compose.ui.graphics.colorspace.Illuminant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\t\u00a8\u0006\u0013"}, d2={"Landroidx/compose/ui/graphics/colorspace/Lab;", "Landroidx/compose/ui/graphics/colorspace/ColorSpace;", "name", "", "id", "", "(Ljava/lang/String;I)V", "isWideGamut", "", "()Z", "fromXyz", "", "v", "getMaxValue", "", "component", "getMinValue", "toXyz", "Companion", "ui-graphics"})
public final class Lab
extends ColorSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final float A = 0.008856452f;
    private static final float B = 7.787037f;
    private static final float C = 0.13793103f;
    private static final float D = 0.20689656f;

    public Lab(@NotNull String name, int id) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, ColorModel.Companion.getLab-xdoWZVw(), id, null);
    }

    @Override
    public boolean isWideGamut() {
        return true;
    }

    @Override
    public float getMinValue(int component) {
        return component == 0 ? 0.0f : -128.0f;
    }

    @Override
    public float getMaxValue(int component) {
        return component == 0 ? 100.0f : 128.0f;
    }

    @Override
    @NotNull
    public float[] toXyz(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        v[0] = RangesKt.coerceIn((float)v[0], (float)0.0f, (float)100.0f);
        v[1] = RangesKt.coerceIn((float)v[1], (float)-128.0f, (float)128.0f);
        v[2] = RangesKt.coerceIn((float)v[2], (float)-128.0f, (float)128.0f);
        float fy = (v[0] + 16.0f) / 116.0f;
        float fx = fy + v[1] * 0.002f;
        float fz = fy - v[2] * 0.005f;
        float x = fx > 0.20689656f ? fx * fx * fx : 0.12841855f * (fx - 0.13793103f);
        float y = fy > 0.20689656f ? fy * fy * fy : 0.12841855f * (fy - 0.13793103f);
        float z = fz > 0.20689656f ? fz * fz * fz : 0.12841855f * (fz - 0.13793103f);
        v[0] = x * Illuminant.INSTANCE.getD50Xyz$ui_graphics()[0];
        v[1] = y * Illuminant.INSTANCE.getD50Xyz$ui_graphics()[1];
        v[2] = z * Illuminant.INSTANCE.getD50Xyz$ui_graphics()[2];
        return v;
    }

    @Override
    @NotNull
    public float[] fromXyz(@NotNull float[] v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        float x = v[0] / Illuminant.INSTANCE.getD50Xyz$ui_graphics()[0];
        float y = v[1] / Illuminant.INSTANCE.getD50Xyz$ui_graphics()[1];
        float z = v[2] / Illuminant.INSTANCE.getD50Xyz$ui_graphics()[2];
        float fx = x > 0.008856452f ? (float)Math.pow(x, 0.33333334f) : 7.787037f * x + 0.13793103f;
        float fy = y > 0.008856452f ? (float)Math.pow(y, 0.33333334f) : 7.787037f * y + 0.13793103f;
        float fz = z > 0.008856452f ? (float)Math.pow(z, 0.33333334f) : 7.787037f * z + 0.13793103f;
        float l = 116.0f * fy - 16.0f;
        float a = 500.0f * (fx - fy);
        float b = 200.0f * (fy - fz);
        v[0] = RangesKt.coerceIn((float)l, (float)0.0f, (float)100.0f);
        v[1] = RangesKt.coerceIn((float)a, (float)-128.0f, (float)128.0f);
        v[2] = RangesKt.coerceIn((float)b, (float)-128.0f, (float)128.0f);
        return v;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Landroidx/compose/ui/graphics/colorspace/Lab$Companion;", "", "()V", "A", "", "B", "C", "D", "ui-graphics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

