/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.psi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.EmptyLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.TextMateLanguage;
import org.jetbrains.plugins.textmate.psi.TextMateFile;
import org.jetbrains.plugins.textmate.psi.TextMateParser;
import org.jetbrains.plugins.textmate.psi.TextMatePsiElement;

public class TextMateParserDefinition
implements ParserDefinition {
    private static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType("TextMate", (Language)TextMateLanguage.LANGUAGE);

    @NotNull
    public Lexer createLexer(Project project) {
        return new EmptyLexer();
    }

    @NotNull
    public PsiParser createParser(Project project) {
        return new TextMateParser();
    }

    @NotNull
    public IFileElementType getFileNodeType() {
        return FILE_ELEMENT_TYPE;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        return new TextMatePsiElement(node.getElementType());
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        return new TextMateFile(viewProvider);
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

