/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.plist;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;
import org.jetbrains.plugins.textmate.plist.PlistValueType;

public class JsonPlistReader
implements PlistReader {
    @Override
    public Plist read(@NotNull InputStream inputStream) throws IOException {
        return JsonPlistReader.internalRead(JsonPlistReader.createJsonReader().readValue((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), Object.class));
    }

    private static Plist internalRead(Object root) throws IOException {
        if (!(root instanceof Map)) {
            throw new IOException("Unknown json format. Root element is '" + root + "'");
        }
        return (Plist)JsonPlistReader.readDict((Map)root).getValue();
    }

    private static PListValue readDict(@NotNull Map<String, Object> map) {
        Plist dict = new Plist();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            PListValue value = JsonPlistReader.readValue(entry.getValue());
            if (value == null) continue;
            dict.setEntry(entry.getKey(), value);
        }
        return PListValue.value(dict, PlistValueType.DICT);
    }

    @Nullable
    private static PListValue readValue(Object value) {
        if (value instanceof Map) {
            return JsonPlistReader.readDict((Map)value);
        }
        if (value instanceof ArrayList) {
            return JsonPlistReader.readArray((ArrayList)value);
        }
        return JsonPlistReader.readBasicValue(value);
    }

    private static PListValue readArray(ArrayList<?> list) {
        ArrayList<PListValue> result = new ArrayList<PListValue>();
        for (Object o : list) {
            PListValue value = JsonPlistReader.readValue(o);
            if (value == null) continue;
            result.add(value);
        }
        return PListValue.value(result, PlistValueType.ARRAY);
    }

    @Nullable
    private static PListValue readBasicValue(Object value) {
        if (value instanceof String) {
            return PListValue.value(value, PlistValueType.STRING);
        }
        if (value instanceof Boolean) {
            return PListValue.value(value, PlistValueType.BOOLEAN);
        }
        if (value instanceof Integer) {
            return PListValue.value((Integer)value, PlistValueType.INTEGER);
        }
        if (value instanceof Double) {
            return PListValue.value(value, PlistValueType.REAL);
        }
        return null;
    }

    public static ObjectMapper createJsonReader() {
        JsonFactory factory = JsonFactory.builder().enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).enable(JsonReadFeature.ALLOW_TRAILING_COMMA).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).build();
        return new ObjectMapper(factory);
    }
}

