/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.selector;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorLexer;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorToken;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateSelectorParser {
    private static final LoggerRt LOG = LoggerRt.getInstance(TextMateSelectorParser.class);
    private static final int NESTING_WEIGH_INITIAL = 100;
    private static final int BASE_WEIGH = 1000;
    private final List<TextMateSelectorToken> myTokens;
    private final CharSequence myHighlightingSelector;
    private int myIndex = 0;

    TextMateSelectorParser(CharSequence highlightingSelector) {
        this.myTokens = TextMateSelectorLexer.tokenize(highlightingSelector);
        this.myHighlightingSelector = highlightingSelector;
    }

    @Nullable
    public Node parse() {
        Node result = this.parseSelectorList();
        if (!this.eof()) {
            LOG.error("Cannot parse highlighting selector: " + this.myHighlightingSelector);
        }
        return result;
    }

    @Nullable
    private Node parseSelectorList() {
        Node node = this.parseConjunction();
        if (node == null || this.getToken() != TextMateSelectorToken.COMMA) {
            return node;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(node);
        while (this.getToken() == TextMateSelectorToken.COMMA) {
            this.advance();
            Node child = this.parseConjunction();
            if (child == null) break;
            children.add(child);
        }
        return new SelectorList(children);
    }

    @Nullable
    private Node parseConjunction() {
        Node node = this.parseScopeSelector();
        if (node == null || this.getToken() != TextMateSelectorToken.PIPE) {
            return node;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        children.add(node);
        while (this.getToken() == TextMateSelectorToken.PIPE) {
            this.advance();
            Node child = this.parseScopeSelector();
            if (child == null) break;
            children.add(child);
        }
        return new Conjunction(children);
    }

    @Nullable
    private Node parseScopeSelector() {
        TextMateWeigh.Priority priority = TextMateWeigh.Priority.NORMAL;
        TextMateSelectorToken token = this.getToken();
        if (token instanceof TextMateSelectorLexer.PriorityToken) {
            this.advance();
            priority = ((TextMateSelectorLexer.PriorityToken)token).getPriority();
        }
        boolean startMatch = false;
        if (this.getToken() == TextMateSelectorToken.HAT) {
            this.advance();
            startMatch = true;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        ArrayList<Node> exclusions = new ArrayList<Node>();
        Node next = this.parseSelector();
        while (next != null) {
            children.add(next);
            next = this.parseSelector();
        }
        while (this.getToken() == TextMateSelectorToken.MINUS) {
            this.advance();
            Node exclusion = this.parseScopeSelector();
            if (exclusion == null) continue;
            exclusions.add(exclusion);
        }
        if (children.isEmpty() && exclusions.isEmpty()) {
            return null;
        }
        return new ScopeSelector(children, exclusions, startMatch, priority);
    }

    @Nullable
    private Node parseSelector() {
        TextMateSelectorToken token = this.getToken();
        if (token == TextMateSelectorToken.LPAREN) {
            this.advance();
            Node result = this.parseSelectorList();
            if (this.getToken() == TextMateSelectorToken.RPAREN) {
                this.advance();
            }
            return result;
        }
        if (token instanceof TextMateSelectorLexer.SelectorToken) {
            this.advance();
            return new Selector(((TextMateSelectorLexer.SelectorToken)token).getText());
        }
        return null;
    }

    @Nullable
    private TextMateSelectorToken getToken() {
        if (this.myIndex < this.myTokens.size()) {
            return this.myTokens.get(this.myIndex);
        }
        return null;
    }

    private void advance() {
        ++this.myIndex;
    }

    private boolean eof() {
        return this.myIndex >= this.myTokens.size();
    }

    static interface Node {
        public TextMateWeigh weigh(@NotNull TextMateScope var1);
    }

    static class SelectorList
    implements Node {
        private final List<Node> children;

        SelectorList(List<Node> children) {
            this.children = children;
        }

        @Override
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            TextMateWeigh result = TextMateWeigh.ZERO;
            for (Node child : this.children) {
                TextMateWeigh weigh = child.weigh(scope);
                if (weigh.compareTo(result) <= 0) continue;
                result = weigh;
            }
            return result;
        }
    }

    static class Conjunction
    implements Node {
        private final List<Node> children;

        Conjunction(List<Node> children) {
            this.children = children;
        }

        @Override
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            for (Node child : this.children) {
                TextMateWeigh weigh = child.weigh(scope);
                if (weigh.weigh <= 0) continue;
                return weigh;
            }
            return TextMateWeigh.ZERO;
        }
    }

    private static final class ScopeSelector
    implements Node {
        private final List<Node> children;
        private final List<Node> exclusions;
        private final boolean startMatch;
        private final TextMateWeigh.Priority priority;

        private ScopeSelector(List<Node> children, List<Node> exclusions, boolean startMatch, TextMateWeigh.Priority priority) {
            this.children = children;
            this.exclusions = exclusions;
            this.startMatch = startMatch;
            this.priority = priority;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            void var3_6;
            for (Node node : this.exclusions) {
                if (node.weigh((TextMateScope)scope).weigh <= 0) continue;
                return TextMateWeigh.ZERO;
            }
            if (scope.getLevel() > 100) {
                return TextMateWeigh.ZERO;
            }
            LinkedList<Node> highlightingSelectors = new LinkedList<Node>();
            for (Node child : this.children) {
                highlightingSelectors.push(child);
            }
            if (highlightingSelectors.isEmpty()) {
                highlightingSelectors.push(new Selector(""));
            }
            TextMateScope textMateScope = scope;
            Node currentHighlightingSelector = (Node)highlightingSelectors.peek();
            int nestingWeigh = 100;
            int result = 0;
            while (!highlightingSelectors.isEmpty() && var3_6 != null) {
                TextMateWeigh weigh;
                TextMateWeigh textMateWeigh = weigh = currentHighlightingSelector instanceof Selector ? currentHighlightingSelector.weigh((TextMateScope)var3_6) : currentHighlightingSelector.weigh(scope);
                if (weigh.weigh > 0) {
                    result += weigh.weigh * nestingWeigh;
                    highlightingSelectors.pop();
                    if (!highlightingSelectors.isEmpty()) {
                        currentHighlightingSelector = (Node)highlightingSelectors.peek();
                    }
                }
                --nestingWeigh;
                TextMateScope textMateScope2 = var3_6.getParent();
            }
            if (!highlightingSelectors.isEmpty()) {
                return TextMateWeigh.ZERO;
            }
            return new TextMateWeigh(!this.startMatch || var3_6 == null || var3_6.isEmpty() ? result : 0, this.priority);
        }
    }

    private static class Selector
    implements Node {
        private final String selector;

        Selector(String selector) {
            this.selector = selector;
        }

        @Override
        public TextMateWeigh weigh(@NotNull TextMateScope scope) {
            CharSequence scopeName = scope.getScopeName();
            if (scopeName != null && StringUtilRt.startsWith((CharSequence)scopeName, (CharSequence)this.selector)) {
                return new TextMateWeigh(1000 - scope.getDotsCount() + Strings.countChars((CharSequence)this.selector, (char)'.'), TextMateWeigh.Priority.NORMAL);
            }
            return TextMateWeigh.ZERO;
        }
    }
}

