/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.openapi.util.text.Strings;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextMateScope {
    public static final TextMateScope EMPTY = new TextMateScope(null, null);
    public static final TextMateScope WHITESPACE = EMPTY.add("token.whitespace");
    @Nullable
    private final CharSequence scopeName;
    @Nullable
    private final TextMateScope parentScope;
    private final int level;
    private final int dotsCount;
    private final int hashCode;
    private final boolean empty;

    public TextMateScope(@Nullable CharSequence scopeName, @Nullable TextMateScope parentScope) {
        this.scopeName = scopeName;
        this.parentScope = parentScope;
        this.dotsCount = (scopeName != null ? Strings.countChars((CharSequence)scopeName, (char)'.') : 0) + (parentScope != null ? parentScope.dotsCount : 0);
        this.hashCode = Objects.hash(scopeName, parentScope);
        this.empty = !(parentScope != null && !parentScope.isEmpty() || scopeName != null && scopeName.length() != 0);
        this.level = parentScope != null ? parentScope.level + 1 : 0;
    }

    public int getDotsCount() {
        return this.dotsCount;
    }

    public int getLevel() {
        return this.level;
    }

    public TextMateScope add(@Nullable CharSequence scopeName) {
        return new TextMateScope(scopeName, this);
    }

    @Nullable
    public CharSequence getScopeName() {
        return this.scopeName;
    }

    @Nullable
    public TextMateScope getParent() {
        return this.parentScope;
    }

    @NotNull
    public TextMateScope getParentOrSelf() {
        return this.parentScope != null ? this.parentScope : this;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.scopeName != null) {
            builder.append(this.scopeName);
        }
        TextMateScope parent = this.parentScope;
        while (parent != null) {
            CharSequence parentScopeName = parent.scopeName;
            if (parentScopeName != null) {
                if (builder.length() > 0) {
                    builder.insert(0, " ");
                }
                builder.insert(0, parentScopeName);
            }
            parent = parent.parentScope;
        }
        return builder.toString().trim();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextMateScope scope = (TextMateScope)o;
        return this.level == scope.level && this.hashCode == scope.hashCode && Objects.equals(this.scopeName, scope.scopeName);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

