/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.intellij.openapi.editor.ex.util.DataStorage;
import com.intellij.openapi.editor.ex.util.ShortBasedStorage;
import com.intellij.psi.tree.IElementType;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateElementType;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public final class TextMateLexerDataStorage
extends ShortBasedStorage {
    private final Object2IntMap<TextMateElementType> tokenTypeMap;
    private final List<TextMateElementType> tokenTypes;

    public TextMateLexerDataStorage() {
        this((Object2IntMap<TextMateElementType>)new Object2IntOpenHashMap(), new ArrayList<TextMateElementType>());
    }

    private TextMateLexerDataStorage(@NotNull Object2IntMap<TextMateElementType> tokenTypeMap, @NotNull List<TextMateElementType> tokenTypes) {
        this.tokenTypeMap = tokenTypeMap;
        this.tokenTypes = tokenTypes;
    }

    private TextMateLexerDataStorage(short @NotNull [] data, @NotNull Object2IntMap<TextMateElementType> tokenTypeMap, @NotNull List<TextMateElementType> tokenTypes) {
        super(data);
        this.tokenTypeMap = tokenTypeMap;
        this.tokenTypes = tokenTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int packData(@NotNull IElementType tokenType, int state, boolean isRestartableState) {
        if (tokenType instanceof TextMateElementType) {
            Object2IntMap<TextMateElementType> object2IntMap = this.tokenTypeMap;
            synchronized (object2IntMap) {
                if (this.tokenTypeMap.containsKey((Object)tokenType)) {
                    return this.tokenTypeMap.getInt((Object)tokenType) * (isRestartableState ? 1 : -1);
                }
                int data = this.tokenTypes.size() + 1;
                this.tokenTypes.add((TextMateElementType)tokenType);
                this.tokenTypeMap.put((Object)((TextMateElementType)tokenType), data);
                return isRestartableState ? data : -data;
            }
        }
        return 0;
    }

    @NotNull
    public IElementType unpackTokenFromData(int data) {
        return data != 0 ? (IElementType)this.tokenTypes.get(Math.abs(data) - 1) : new TextMateElementType(TextMateScope.EMPTY);
    }

    @NotNull
    public DataStorage copy() {
        return new TextMateLexerDataStorage(this.myData, this.tokenTypeMap, this.tokenTypes);
    }

    @NotNull
    public DataStorage createStorage() {
        return new TextMateLexerDataStorage(this.tokenTypeMap, this.tokenTypes);
    }
}

