/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public class TextMateTextAttributes {
    private final String foreground;
    private final String background;
    private final FontStyle fontStyle;

    public TextMateTextAttributes(@Nullable String foreground, @Nullable String background, @NotNull FontStyle style) {
        this.foreground = foreground;
        this.background = background;
        this.fontStyle = style;
    }

    @Nullable
    public String getForeground() {
        return this.foreground;
    }

    @Nullable
    public String getBackground() {
        return this.background;
    }

    @NotNull
    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Nullable
    public static TextMateTextAttributes fromPlist(@NotNull Plist settingsPlist) {
        boolean empty = true;
        String foreground = null;
        String background = null;
        FontStyle fontStyle = FontStyle.PLAIN;
        for (Map.Entry<String, PListValue> entry : settingsPlist.entries()) {
            String propertyName = entry.getKey();
            String value = entry.getValue().getString();
            if ("foreground".equalsIgnoreCase(propertyName)) {
                foreground = value;
                empty = false;
                continue;
            }
            if ("fontStyle".equalsIgnoreCase(propertyName)) {
                if ("italic".equalsIgnoreCase(value)) {
                    fontStyle = FontStyle.ITALIC;
                    empty = false;
                    continue;
                }
                if ("bold".equalsIgnoreCase(value)) {
                    fontStyle = FontStyle.BOLD;
                    empty = false;
                    continue;
                }
                if ("underline".equalsIgnoreCase(value)) {
                    fontStyle = FontStyle.UNDERLINE;
                    empty = false;
                    continue;
                }
                fontStyle = FontStyle.PLAIN;
                empty = false;
                continue;
            }
            if (!"background".equalsIgnoreCase(propertyName)) continue;
            background = value;
            empty = false;
        }
        return empty ? null : new TextMateTextAttributes(foreground, background, fontStyle);
    }

    public static enum FontStyle {
        PLAIN,
        ITALIC,
        BOLD,
        UNDERLINE;

    }
}

