/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.TextMateScopeComparator;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;

public class SnippetsRegistryImpl
implements SnippetsRegistry {
    @NotNull
    private final Map<String, Collection<TextMateSnippet>> mySnippets = new HashMap<String, Collection<TextMateSnippet>>();

    public void register(@NotNull TextMateSnippet snippet) {
        this.mySnippets.computeIfAbsent(snippet.getKey(), key -> new ArrayList()).add(snippet);
    }

    @Override
    @NotNull
    public Collection<TextMateSnippet> findSnippet(@NotNull String key, @Nullable TextMateScope scope) {
        if (scope == null) {
            return Collections.emptyList();
        }
        Collection<TextMateSnippet> snippets = this.mySnippets.get(key);
        if (snippets == null) {
            return Collections.emptyList();
        }
        return new TextMateScopeComparator<TextMateSnippet>(scope, TextMateSnippet::getScopeSelector).sortAndFilter(snippets);
    }

    @Override
    @NotNull
    public Collection<TextMateSnippet> getAvailableSnippets(@Nullable TextMateScope scopeSelector) {
        if (scopeSelector == null) {
            return Collections.emptyList();
        }
        return new TextMateScopeComparator<TextMateSnippet>(scopeSelector, TextMateSnippet::getScopeSelector).sortAndFilter(this.mySnippets.values().stream().flatMap(values -> values.stream()));
    }

    public void clear() {
        this.mySnippets.clear();
    }
}

