/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorCachingWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateSelectorWeigherImpl;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;

public class TextMateScopeComparator<T>
implements Comparator<T> {
    @NotNull
    private static final TextMateSelectorWeigher myWeigher = new TextMateSelectorCachingWeigher(new TextMateSelectorWeigherImpl());
    @NotNull
    private final TextMateScope myScope;
    @NotNull
    private final Function<? super T, ? extends CharSequence> myScopeSupplier;

    public TextMateScopeComparator(@NotNull TextMateScope scope, @NotNull Function<? super T, ? extends CharSequence> scopeSupplier) {
        this.myScope = scope;
        this.myScopeSupplier = scopeSupplier;
    }

    @Override
    public int compare(T first, T second) {
        return myWeigher.weigh(this.myScopeSupplier.apply(first), this.myScope).compareTo(myWeigher.weigh(this.myScopeSupplier.apply(second), this.myScope));
    }

    @NotNull
    public List<T> sortAndFilter(@NotNull Collection<? extends T> objects) {
        return this.sortAndFilter(objects.stream());
    }

    @NotNull
    public List<T> sortAndFilter(Stream<? extends T> stream) {
        return stream.filter(t -> TextMateScopeComparator.myWeigher.weigh((CharSequence)this.myScopeSupplier.apply(t), (TextMateScope)this.myScope).weigh > 0).sorted(Collections.reverseOrder(this)).collect(Collectors.toList());
    }

    @Nullable
    public T max(Collection<T> objects) {
        TextMateWeigh max = TextMateWeigh.ZERO;
        T result = null;
        for (T object : objects) {
            TextMateWeigh weigh = myWeigher.weigh(this.myScopeSupplier.apply(object), this.myScope);
            if (weigh.weigh <= 0 || weigh.compareTo(max) <= 0) continue;
            max = weigh;
            result = object;
        }
        return result;
    }
}

