/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language;

import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.TextMateBlockCommentPair;
import org.jetbrains.plugins.textmate.language.TextMateCommentPrefixes;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;

public final class PreferencesReadUtil {
    @Nullable
    public static Map.Entry<String, Plist> retrieveSettingsPlist(Plist rootPlist) {
        String scopeName = null;
        Plist settingsValuePlist = null;
        PListValue value = rootPlist.getPlistValue("scope");
        if (value != null) {
            scopeName = value.getString();
            PListValue settingsValue = rootPlist.getPlistValue("settings");
            if (scopeName != null && !scopeName.isEmpty() && settingsValue != null) {
                settingsValuePlist = settingsValue.getPlist();
            }
        }
        return settingsValuePlist != null ? Map.entry(scopeName, settingsValuePlist) : null;
    }

    @Nullable
    public static Set<TextMateBracePair> readPairs(@Nullable PListValue pairsValue) {
        if (pairsValue == null) {
            return null;
        }
        HashSet result = new HashSet();
        List<PListValue> pairs = pairsValue.getArray();
        for (PListValue pair : pairs) {
            List<PListValue> chars = pair.getArray();
            if (chars.size() != 2) continue;
            String left = chars.get(0).getString();
            String right = chars.get(1).getString();
            if (left.length() != 1 || right.length() != 1) continue;
            result.add(new TextMateBracePair(left.charAt(0), right.charAt(0)));
        }
        return result.isEmpty() ? Collections.emptySet() : result;
    }

    @Nullable
    private static TextMateSnippet loadTextMateSnippet(@NotNull Plist plist, @NotNull String filePath, @NotNull Interner<CharSequence> interner) {
        String name = plist.getPlistValue("name", "").getString();
        String key = plist.getPlistValue("tabTrigger", "").getString();
        String content = plist.getPlistValue(Constants.StringKey.CONTENT.value, "").getString();
        String scope = plist.getPlistValue("scope", "").getString();
        String description = plist.getPlistValue("description", "").getString();
        Object uuid = plist.getPlistValue("uuid", "").getString();
        if (!key.isEmpty() && !content.isEmpty()) {
            if (name.isEmpty()) {
                name = key;
            }
            if (((String)uuid).isEmpty()) {
                uuid = filePath + ":" + name;
            }
            return new TextMateSnippet(key, content, (CharSequence)interner.intern((Object)scope), name, description, (String)uuid);
        }
        return null;
    }

    @NotNull
    public static <K, V> Map<K, V> compactMap(@NotNull Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry<K, V> singleEntry = map.entrySet().iterator().next();
            return Collections.singletonMap(singleEntry.getKey(), singleEntry.getValue());
        }
        if (!(map instanceof HashMap)) {
            return map;
        }
        HashMap<K, V> result = new HashMap<K, V>(map.size(), 1.0f);
        result.putAll(map);
        return result;
    }

    private PreferencesReadUtil() {
    }

    @Nullable
    public static TextMateSnippet loadSnippet(@NotNull File snippetFile, @NotNull Plist plist, @NotNull Interner<CharSequence> interner) {
        return snippetFile.getName().endsWith(".sublime-snippet") ? null : PreferencesReadUtil.loadTextMateSnippet(plist, snippetFile.getAbsolutePath(), interner);
    }

    @Nullable
    private static String getPattern(@NotNull String name, @NotNull Plist from) {
        PListValue value = from.getPlistValue(name);
        if (value == null) {
            return null;
        }
        return value.getString();
    }

    @NotNull
    public static IndentationRules loadIndentationRules(@NotNull Plist plist) {
        PListValue rulesValue = plist.getPlistValue("indentationRules");
        if (rulesValue == null) {
            return IndentationRules.empty();
        }
        Plist rules = rulesValue.getPlist();
        return new IndentationRules(PreferencesReadUtil.getPattern("increaseIndentPattern", rules), PreferencesReadUtil.getPattern("decreaseIndentPattern", rules), PreferencesReadUtil.getPattern("indentNextLinePattern", rules), PreferencesReadUtil.getPattern("unIndentedLinePattern", rules));
    }

    @NotNull
    public static TextMateCommentPrefixes readCommentPrefixes(@NotNull ShellVariablesRegistry registry, @NotNull TextMateScope scope) {
        String lineCommentPrefix = null;
        TextMateBlockCommentPair blockCommentPair = null;
        int index = 1;
        while (lineCommentPrefix == null || blockCommentPair == null) {
            Object variableSuffix = index > 1 ? "_" + index : "";
            TextMateShellVariable start = registry.getVariableValue("TM_COMMENT_START" + (String)variableSuffix, scope);
            TextMateShellVariable end = registry.getVariableValue("TM_COMMENT_END" + (String)variableSuffix, scope);
            ++index;
            if (start == null) break;
            if (!(end != null && end.scopeName.equals(start.scopeName) || lineCommentPrefix != null)) {
                lineCommentPrefix = start.value;
            }
            if (end == null || !end.scopeName.equals(start.scopeName) || blockCommentPair != null) continue;
            blockCommentPair = new TextMateBlockCommentPair(start.value, end.value);
        }
        return new TextMateCommentPrefixes(lineCommentPrefix, blockCommentPair);
    }
}

