/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.psi.TextMateFile;

public class TextMateCustomLiveTemplate
extends CustomLiveTemplateBase {
    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback) {
        CharSequence result = "";
        Editor editor = callback.getEditor();
        CharSequence sequence = editor.getDocument().getImmutableCharSequence();
        Collection<TextMateSnippet> availableSnippets = TextMateCustomLiveTemplate.getAvailableSnippets(editor);
        for (TextMateSnippet snippet : availableSnippets) {
            CharSequence prefix = TextMateCustomLiveTemplate.getPrefixForSnippet(sequence, editor.getCaretModel().getOffset(), snippet);
            if (prefix == null || prefix.length() <= result.length()) continue;
            result = prefix;
        }
        return !availableSnippets.isEmpty() ? result.toString() : null;
    }

    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        int offset = callback.getEditor().getCaretModel().getOffset();
        CharSequence charsSequence = callback.getEditor().getDocument().getImmutableCharSequence();
        for (TextMateSnippet snippet : TextMateCustomLiveTemplate.getAvailableSnippets(callback.getEditor())) {
            String key = snippet.getKey();
            if (key.length() > offset || !StringUtil.equals((CharSequence)key, (CharSequence)charsSequence.subSequence(offset - key.length(), offset))) continue;
            return key;
        }
        return null;
    }

    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        TextMateService service = TextMateService.getInstance();
        if (service != null) {
            Editor editor;
            TextMateScope scope;
            SnippetsRegistry snippetsRegistry = service.getSnippetsRegistry();
            Collection<TextMateSnippet> snippets = snippetsRegistry.findSnippet(key, scope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)(editor = callback.getEditor())));
            if (snippets.size() > 1) {
                LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)callback.getProject()).createLookup(editor, LookupElement.EMPTY_ARRAY, "", (LookupArranger)new LookupArranger.DefaultArranger());
                for (TextMateSnippet snippet : snippets) {
                    lookup.addItem((LookupElement)new TextMateSnippetLookupElement(snippet), (PrefixMatcher)new PlainPrefixMatcher(key));
                }
                Project project = editor.getProject();
                lookup.addLookupListener((LookupListener)new MyLookupAdapter(project, editor, callback.getFile()));
                lookup.refreshUi(false, true);
                lookup.showLookup();
            } else if (snippets.size() == 1) {
                TextMateSnippet snippet = (TextMateSnippet)ContainerUtil.getFirstItem(snippets);
                assert (snippet != null);
                TextMateCustomLiveTemplate.expand(editor, snippet);
            }
        }
    }

    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback) {
    }

    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file, @NotNull Editor editor, int offset) {
        TextMateService service = TextMateService.getInstance();
        if (service == null) {
            return super.getLookupElements(file, editor, offset);
        }
        return ContainerUtil.map(TextMateCustomLiveTemplate.getAvailableSnippets(editor), snippet -> new TextMateSnippetLookupElement((TextMateSnippet)snippet));
    }

    public void addCompletions(CompletionParameters parameters, CompletionResultSet result) {
        int endOffset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        CharSequence sequence = editor.getDocument().getImmutableCharSequence();
        for (TextMateSnippet snippet : TextMateCustomLiveTemplate.getAvailableSnippets(editor)) {
            CharSequence prefix = TextMateCustomLiveTemplate.getPrefixForSnippet(sequence, endOffset, snippet);
            if (prefix == null || !StringUtil.startsWith((CharSequence)snippet.getKey(), (CharSequence)prefix)) continue;
            result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(prefix.toString())).addElement((LookupElement)new TextMateSnippetLookupElement(snippet));
        }
    }

    public boolean isApplicable(@NotNull CustomTemplateCallback callback, int offset, boolean wrapping) {
        PsiFile file = callback.getFile();
        return file instanceof TextMateFile && ApplicationManager.getApplication().isInternal();
    }

    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback, int offset) {
        return this.isApplicable(callback, offset, false);
    }

    public char getShortcut() {
        return '\t';
    }

    public boolean supportsWrapping() {
        return true;
    }

    @NotNull
    public String getTitle() {
        return TextMateBundle.message("textmate.live.template.name", new Object[0]);
    }

    @NotNull
    private static Collection<TextMateSnippet> getAvailableSnippets(@NotNull Editor editor) {
        TextMateService service = TextMateService.getInstance();
        if (service != null) {
            SnippetsRegistry snippetsRegistry = service.getSnippetsRegistry();
            TextMateScope scope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
            return snippetsRegistry.getAvailableSnippets(scope);
        }
        return Collections.emptyList();
    }

    @Nullable
    private static CharSequence getPrefixForSnippet(@NotNull CharSequence sequence, int offset, @NotNull TextMateSnippet snippet) {
        int startOffset;
        for (int i = startOffset = Math.max(offset - snippet.getKey().length(), 0); i <= offset; ++i) {
            if (i != 0 && !StringUtil.isWhiteSpace((char)sequence.charAt(i - 1))) continue;
            CharSequence prefix = sequence.subSequence(i, offset);
            if (!StringUtil.startsWith((CharSequence)snippet.getKey(), (CharSequence)prefix)) continue;
            return prefix;
        }
        return null;
    }

    private static void expand(@NotNull Editor editor, @NotNull TextMateSnippet snippet) {
        String key = snippet.getKey();
        int offset = editor.getCaretModel().getOffset();
        int newOffset = Math.max(offset - key.length(), 0);
        editor.getDocument().deleteString(newOffset, offset);
        editor.getCaretModel().moveToOffset(newOffset);
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)snippet.getContent());
    }

    private class TextMateSnippetLookupElement
    extends CustomLiveTemplateLookupElement {
        private final TextMateSnippet mySnippet;

        TextMateSnippetLookupElement(TextMateSnippet snippet) {
            super((CustomLiveTemplateBase)TextMateCustomLiveTemplate.this, snippet.getKey(), snippet.getKey(), snippet.getDescription(), false, true);
            this.mySnippet = snippet;
        }

        public void expandTemplate(@NotNull Editor editor, @NotNull PsiFile file) {
            TextMateCustomLiveTemplate.expand(editor, this.mySnippet);
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            super.renderElement(presentation);
            presentation.setTypeText(this.mySnippet.getName());
            presentation.setTypeGrayed(true);
        }
    }

    private static class MyLookupAdapter
    implements LookupListener {
        private final Project myProject;
        private final Editor myEditor;
        private final PsiFile myFile;

        MyLookupAdapter(Project project, Editor editor, PsiFile file) {
            this.myProject = project;
            this.myEditor = editor;
            this.myFile = file;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            LookupElement item = event.getItem();
            assert (item instanceof CustomLiveTemplateLookupElement);
            if (this.myFile != null) {
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)TextMateBundle.message("textmate.expand.live.template.command.name", new Object[0]), null, () -> ((CustomLiveTemplateLookupElement)item).expandTemplate(this.myEditor, this.myFile), (PsiFile[])new PsiFile[]{this.myFile});
            }
        }
    }
}

