/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateBundlesListPanel;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;

public class TextMateSettingsUI
implements ConfigurableUi<TextMateSettings>,
Disposable {
    private final TextMateBundlesListPanel myBundlesListPanel = new TextMateBundlesListPanel();
    private final JPanel myBundlesList = this.myBundlesListPanel.createMainComponent();

    public TextMateSettingsUI() {
        Disposer.register((Disposable)this, (Disposable)this.myBundlesListPanel);
    }

    public void apply(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state = settings.getState();
        if (state == null) {
            state = new TextMateSettings.TextMateSettingsState();
        }
        List<BundleConfigBean> newBundles = state.getBundles();
        settings.loadState(state);
        if (this.myBundlesListPanel.isModified(newBundles)) {
            state.setBundles(this.myBundlesListPanel.getState());
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(null, TextMateBundle.message("textmate.loading.bundles.title", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

                public void run(@NotNull ProgressIndicator indicator) {
                    TextMateService.getInstance().reloadEnabledBundles();
                }
            });
        }
    }

    public void reset(@NotNull TextMateSettings settings) {
        this.myBundlesListPanel.setState(settings.getBundles());
    }

    public boolean isModified(@NotNull TextMateSettings settings) {
        TextMateSettings.TextMateSettingsState state = settings.getState();
        if (state == null) {
            return !this.myBundlesListPanel.getState().isEmpty();
        }
        return this.myBundlesListPanel.isModified(state.getBundles());
    }

    @NotNull
    public JComponent getComponent() {
        return this.myBundlesList;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myBundlesList;
    }

    public void dispose() {
    }
}

