/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.bundles.Bundle;
import org.jetbrains.plugins.textmate.bundles.BundleFactory;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.TextMateLanguageDescriptor;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.PreferencesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistry;
import org.jetbrains.plugins.textmate.language.preferences.ShellVariablesRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistryImpl;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.language.syntax.TextMateSyntaxTable;
import org.jetbrains.plugins.textmate.language.syntax.highlighting.TextMateTextAttributesAdapter;
import org.jetbrains.plugins.textmate.language.syntax.lexer.SyntaxMatchUtils;
import org.jetbrains.plugins.textmate.plist.CompositePlistReader;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

public final class TextMateServiceImpl
extends TextMateService {
    public static final String BUNDLED_BUNDLES_PATH = PluginPathManager.getPluginHome((String)"textmate") + "/lib/bundles";
    private boolean ourBuiltinBundlesDisabled;
    private volatile boolean myInitialized;
    private final Lock myRegistrationLock = new ReentrantLock();
    private final Map<CharSequence, TextMateTextAttributesAdapter> myCustomHighlightingColors = new HashMap<CharSequence, TextMateTextAttributesAdapter>();
    private Map<String, CharSequence> myExtensionsMapping = new HashMap<String, CharSequence>();
    private final PlistReader myPlistReader = new CompositePlistReader();
    private final BundleFactory myBundleFactory = new BundleFactory(this.myPlistReader);
    private final TextMateSyntaxTable mySyntaxTable = new TextMateSyntaxTable();
    private final SnippetsRegistryImpl mySnippetsRegistry = new SnippetsRegistryImpl();
    private final PreferencesRegistryImpl myPreferencesRegistry = new PreferencesRegistryImpl();
    private final ShellVariablesRegistryImpl myShellVariablesRegistry = new ShellVariablesRegistryImpl();
    private final Interner<CharSequence> myInterner = Interner.createWeakInterner();

    public TextMateServiceImpl() {
        Application application = ApplicationManager.getApplication();
        Runnable checkCancelled = application != null && !application.isUnitTestMode() ? ProgressManager::checkCanceled : null;
        SyntaxMatchUtils.setCheckCancelledCallback(checkCancelled);
    }

    @Override
    public void reloadEnabledBundles() {
        this.registerBundles(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerBundles(boolean fireEvents) {
        this.myRegistrationLock.lock();
        try {
            HashMap<String, CharSequence> oldExtensionsMapping = new HashMap<String, CharSequence>(this.myExtensionsMapping);
            this.unregisterAllBundles();
            TextMateSettings settings = TextMateSettings.getInstance();
            if (settings == null) {
                return;
            }
            if (!this.ourBuiltinBundlesDisabled) {
                TextMateServiceImpl.loadBuiltinBundles(settings);
            }
            HashMap<String, CharSequence> newExtensionsMapping = new HashMap<String, CharSequence>();
            for (BundleConfigBean bundleConfigBean : settings.getBundles()) {
                VirtualFile bundleFile;
                boolean result;
                if (!bundleConfigBean.isEnabled() || (result = this.registerBundle(bundleFile = LocalFileSystem.getInstance().findFileByPath(bundleConfigBean.getPath()), newExtensionsMapping)) || bundleFile == null && bundleConfigBean.getPath().startsWith(BUNDLED_BUNDLES_PATH)) continue;
                String bundleName = bundleConfigBean.getName();
                String errorMessage = bundleFile != null ? TextMateBundle.message("textmate.cant.register.bundle", bundleName) : TextMateBundle.message("textmate.cant.find.bundle", bundleName);
                new Notification("TextMate Bundles", TextMateBundle.message("textmate.bundle.load.error", bundleName), errorMessage, NotificationType.ERROR).addAction((AnAction)NotificationAction.createSimpleExpiring((String)TextMateBundle.message("textmate.disable.bundle.notification.action", bundleName), () -> bundleConfigBean.setEnabled(false))).notify(null);
            }
            if (!oldExtensionsMapping.equals(newExtensionsMapping)) {
                if (fireEvents) {
                    TextMateServiceImpl.fireFileTypesChangedEvent("old mappings = " + oldExtensionsMapping + ", new mappings" + newExtensionsMapping, () -> {
                        this.myExtensionsMapping = newExtensionsMapping;
                    });
                } else {
                    this.myExtensionsMapping = newExtensionsMapping;
                }
            }
            this.mySyntaxTable.compact();
        }
        finally {
            this.myRegistrationLock.unlock();
        }
    }

    private static void fireFileTypesChangedEvent(@NonNls @NotNull String reason, @NotNull Runnable update) {
        ApplicationManager.getApplication().invokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            FileTypeManagerImpl fileTypeManager = (FileTypeManagerImpl)FileTypeManager.getInstance();
            fileTypeManager.makeFileTypesChange(reason, update);
        }), ModalityState.NON_MODAL);
    }

    private static void loadBuiltinBundles(TextMateSettings settings) {
        File bundles = new File(BUNDLED_BUNDLES_PATH);
        File[] files = bundles.listFiles();
        if (files == null) {
            LOG.warn("Builtin bundles not found at " + bundles);
            return;
        }
        TextMateSettings.TextMateSettingsState state = settings.getState();
        state = state == null ? new TextMateSettings.TextMateSettingsState() : state;
        List<BundleConfigBean> oldBundles = state.getBundles();
        ArrayList<BundleConfigBean> newBundles = new ArrayList<BundleConfigBean>(oldBundles);
        for (File file : files) {
            String path;
            BundleConfigBean existing;
            if (file.getName().startsWith(".") || (existing = (BundleConfigBean)ContainerUtil.find(oldBundles, arg_0 -> TextMateServiceImpl.lambda$loadBuiltinBundles$4(path = FileUtil.toSystemIndependentName((String)file.getPath()), arg_0))) != null) continue;
            newBundles.add(new BundleConfigBean(file.getName(), path, true));
        }
        state.setBundles(newBundles);
        settings.loadState(state);
    }

    private void unregisterAllBundles() {
        this.myExtensionsMapping.clear();
        this.myPreferencesRegistry.clear();
        this.myCustomHighlightingColors.clear();
        this.mySyntaxTable.clear();
        this.mySnippetsRegistry.clear();
        this.myShellVariablesRegistry.clear();
    }

    @Override
    @NotNull
    public Map<CharSequence, TextMateTextAttributesAdapter> getCustomHighlightingColors() {
        this.ensureInitialized();
        return this.myCustomHighlightingColors;
    }

    @Override
    @NotNull
    public ShellVariablesRegistry getShellVariableRegistry() {
        this.ensureInitialized();
        return this.myShellVariablesRegistry;
    }

    @Override
    @Nullable
    public TextMateShellVariable getVariable(@NotNull String name, @NotNull EditorEx editor) {
        this.ensureInitialized();
        return this.myShellVariablesRegistry.getVariableValue(name, TextMateEditorUtils.getCurrentScopeSelector(editor));
    }

    @Override
    @NotNull
    public SnippetsRegistry getSnippetsRegistry() {
        this.ensureInitialized();
        return this.mySnippetsRegistry;
    }

    @Override
    @NotNull
    public PreferencesRegistry getPreferencesRegistry() {
        this.ensureInitialized();
        return this.myPreferencesRegistry;
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByFileName(@NotNull CharSequence fileName) {
        if (Strings.isEmpty((CharSequence)fileName)) {
            return null;
        }
        this.ensureInitialized();
        Ref result = new Ref();
        TextMateEditorUtils.processExtensions(fileName, (Processor<? super CharSequence>)((Processor)extension -> {
            result.set((Object)this.getLanguageDescriptorByExtension((CharSequence)extension));
            return result.isNull();
        }));
        return (TextMateLanguageDescriptor)result.get();
    }

    @Override
    @Nullable
    public TextMateLanguageDescriptor getLanguageDescriptorByExtension(@Nullable CharSequence extension) {
        if (Strings.isEmpty((CharSequence)extension)) {
            return null;
        }
        this.ensureInitialized();
        CharSequence scopeName = this.myExtensionsMapping.get(Strings.toLowerCase((String)extension.toString()));
        return !Strings.isEmpty((CharSequence)scopeName) ? new TextMateLanguageDescriptor(scopeName, this.mySyntaxTable.getSyntax(scopeName)) : null;
    }

    @Override
    @Nullable
    public Bundle createBundle(@Nullable VirtualFile directory) {
        String path;
        if (directory != null && directory.isInLocalFileSystem() && (path = directory.getCanonicalPath()) != null) {
            try {
                return this.myBundleFactory.fromDirectory(new File(path));
            }
            catch (IOException e) {
                LOG.debug("Couldn't load bundle from " + path, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private void ensureInitialized() {
        if (!this.myInitialized) {
            this.myRegistrationLock.lock();
            try {
                if (this.myInitialized) {
                    return;
                }
                this.registerBundles(false);
                this.myInitialized = true;
            }
            finally {
                this.myRegistrationLock.unlock();
            }
        }
    }

    private boolean registerBundle(@Nullable VirtualFile directory, @NotNull Map<String, CharSequence> extensionsMapping) {
        Bundle bundle = this.createBundle(directory);
        if (bundle != null) {
            this.registerLanguageSupport(bundle, extensionsMapping);
            this.registerPreferences(bundle);
            this.registerSnippets(bundle);
            return true;
        }
        return false;
    }

    private void registerSnippets(@NotNull Bundle bundle) {
        for (File snippetFile : bundle.getSnippetFiles()) {
            try {
                TextMateSnippet snippet = PreferencesReadUtil.loadSnippet(snippetFile, this.myPlistReader.read(snippetFile), this.myInterner);
                if (snippet == null) continue;
                this.mySnippetsRegistry.register(snippet);
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + snippetFile.getPath());
            }
        }
    }

    private void registerPreferences(@NotNull Bundle bundle) {
        for (File preferenceFile : bundle.getPreferenceFiles()) {
            try {
                for (Map.Entry<String, Plist> settingsPair : bundle.loadPreferenceFile(preferenceFile, this.myPlistReader)) {
                    if (settingsPair == null) continue;
                    CharSequence scopeName = (CharSequence)this.myInterner.intern((Object)settingsPair.getKey());
                    this.myPreferencesRegistry.fillFromPList(scopeName, settingsPair.getValue());
                    this.myShellVariablesRegistry.fillVariablesFromPlist(scopeName, settingsPair.getValue());
                    this.readCustomHighlightingColors(scopeName, settingsPair.getValue());
                }
            }
            catch (IOException e) {
                LOG.debug("Can't load textmate preferences file: " + preferenceFile.getPath());
            }
        }
    }

    private void readCustomHighlightingColors(@NotNull CharSequence scopeName, @NotNull Plist preferencesPList) {
        TextMateTextAttributes textAttributes = TextMateTextAttributes.fromPlist(preferencesPList);
        if (textAttributes != null) {
            this.myCustomHighlightingColors.put(scopeName, new TextMateTextAttributesAdapter(scopeName, textAttributes));
        }
    }

    private void registerLanguageSupport(@NotNull Bundle bundle, @NotNull Map<String, CharSequence> extensionsMapping) {
        for (File grammarFile : bundle.getGrammarFiles()) {
            try {
                Plist plist = this.myPlistReader.read(grammarFile);
                CharSequence rootScopeName = this.mySyntaxTable.loadSyntax(plist, this.myInterner);
                Collection<String> extensions = bundle.getExtensions(grammarFile, plist);
                for (String extension : extensions) {
                    extensionsMapping.put(Strings.toLowerCase((String)extension), rootScopeName);
                }
            }
            catch (IOException e) {
                LOG.warn("Can't load textmate language file: " + grammarFile.getPath());
            }
        }
    }

    @TestOnly
    public void disableBuiltinBundles(Disposable disposable) {
        this.ourBuiltinBundlesDisabled = true;
        TextMateService.getInstance().reloadEnabledBundles();
        this.myInitialized = true;
        Disposer.register((Disposable)disposable, () -> {
            this.ourBuiltinBundlesDisabled = false;
            this.unregisterAllBundles();
            this.myInitialized = false;
        });
    }

    private static /* synthetic */ boolean lambda$loadBuiltinBundles$4(String path, BundleConfigBean bundle) {
        return bundle.getPath().equals(path);
    }
}

